/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.MultivariateBrownianMotion;

public class MultivariateBrownianMotionBridge
extends MultivariateBrownianMotion {
    protected double[] z;
    protected double[] covZCholDecompz;
    protected int bridgeCounter = -1;
    protected double[] wMuDt;
    protected double[] wSqrtDt;
    protected int[] wIndexList;
    protected int[] ptIndex;

    public MultivariateBrownianMotionBridge(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, RandomStream stream) {
        this.setParams(c, x0, mu, sigma, corrZ);
        this.gen = new NormalGen(stream, new NormalDist());
        this.z = new double[c];
        this.covZCholDecompz = new double[c];
    }

    public MultivariateBrownianMotionBridge(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, NormalGen gen) {
        this.setParams(c, x0, mu, sigma, corrZ);
        this.gen = gen;
        this.z = new double[c];
        this.covZCholDecompz = new double[c];
    }

    @Override
    public double[] generatePath() {
        int i;
        if (!this.covZiSCholDecomp) {
            this.initCovZCholDecomp();
        }
        for (i = 0; i < this.c; ++i) {
            this.z[i] = this.gen.nextDouble();
        }
        this.computeAZ(this.covZCholDecomp, this.z, this.covZCholDecompz);
        for (i = 0; i < this.c; ++i) {
            this.path[this.c * this.d + i] = this.x0[i] + this.mu[i] * (this.t[this.d] - this.t[0]) + this.wSqrtDt[0] * this.covZCholDecompz[i];
        }
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            for (i = 0; i < this.c; ++i) {
                this.z[i] = this.gen.nextDouble();
            }
            this.computeAZ(this.covZCholDecomp, this.z, this.covZCholDecompz);
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            for (i = 0; i < this.c; ++i) {
                this.path[this.c * newIndex + i] = this.path[this.c * oldIndexL + i] + (this.path[this.c * oldIndexR + i] - this.path[this.c * oldIndexL + i]) * this.wMuDt[newIndex] + this.wSqrtDt[newIndex] * this.covZCholDecompz[i];
            }
        }
        this.observationIndex = this.observationCounter = this.c * this.d;
        return this.path;
    }

    @Override
    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.bridgeCounter = -1;
    }

    @Override
    public double[] nextObservationVector() {
        throw new UnsupportedOperationException("nextObservationVector is not implemented ");
    }

    @Override
    public void nextObservationVector(double[] obs) {
        throw new UnsupportedOperationException("nextObservationVector is not implemented ");
    }

    @Override
    protected void init() {
        super.init();
        this.wMuDt = new double[this.d + 1];
        this.wSqrtDt = new double[this.d + 1];
        this.wIndexList = new int[3 * this.d];
        this.ptIndex = new int[this.d + 1];
        int indexCounter = 0;
        for (int i = 0; i < this.c; ++i) {
            this.path[i] = this.x0[i];
        }
        this.ptIndex[0] = 0;
        this.ptIndex[1] = this.d;
        this.wMuDt[0] = 0.0;
        this.wSqrtDt[0] = Math.sqrt(this.t[this.d] - this.t[0]);
        for (int powOfTwo = 1; powOfTwo <= this.d / 2; powOfTwo *= 2) {
            int j;
            for (j = powOfTwo; j >= 1; --j) {
                this.ptIndex[2 * j] = this.ptIndex[j];
            }
            for (j = 1; j <= powOfTwo; ++j) {
                int oldLeft = 2 * j - 2;
                int oldRight = 2 * j;
                int newIndex = (int)(0.5 * (double)(this.ptIndex[oldLeft] + this.ptIndex[oldRight]));
                this.wMuDt[newIndex] = (this.t[newIndex] - this.t[this.ptIndex[oldLeft]]) / (this.t[this.ptIndex[oldRight]] - this.t[this.ptIndex[oldLeft]]);
                this.wSqrtDt[newIndex] = Math.sqrt((this.t[newIndex] - this.t[this.ptIndex[oldLeft]]) * (this.t[this.ptIndex[oldRight]] - this.t[newIndex]) / (this.t[this.ptIndex[oldRight]] - this.t[this.ptIndex[oldLeft]]));
                this.ptIndex[oldLeft + 1] = newIndex;
                this.wIndexList[indexCounter] = this.ptIndex[oldLeft];
                this.wIndexList[indexCounter + 1] = newIndex;
                this.wIndexList[indexCounter + 2] = this.ptIndex[oldRight];
                indexCounter += 3;
            }
        }
        for (int k = 1; k < this.d; ++k) {
            if (this.ptIndex[k - 1] + 1 >= this.ptIndex[k]) continue;
            this.wMuDt[this.ptIndex[k - 1] + 1] = (this.t[this.ptIndex[k - 1] + 1] - this.t[this.ptIndex[k - 1]]) / (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1]]);
            this.wSqrtDt[this.ptIndex[k - 1] + 1] = Math.sqrt((this.t[this.ptIndex[k - 1] + 1] - this.t[this.ptIndex[k - 1]]) * (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1] + 1]) / (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1]]));
            this.wIndexList[indexCounter] = this.ptIndex[k] - 2;
            this.wIndexList[indexCounter + 1] = this.ptIndex[k] - 1;
            this.wIndexList[indexCounter + 2] = this.ptIndex[k];
            indexCounter += 3;
        }
    }

    private void computeAZ(DoubleMatrix2D A, double[] z, double[] Az) {
        for (int i = 0; i < this.c; ++i) {
            double sum = 0.0;
            for (int k = 0; k < this.c; ++k) {
                sum += A.getQuick(i, k) * z[k];
            }
            Az[i] = sum;
        }
    }
}

