/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.MultivariateBrownianMotion;
import umontreal.ssj.stochprocess.MultivariateStochasticProcess;

public class MultivariateGeometricBrownianMotion
extends MultivariateStochasticProcess {
    protected NormalGen gen;
    protected MultivariateBrownianMotion mbm;
    protected double[] mu;
    protected double[] sigma;
    protected double[] mudt;

    public MultivariateGeometricBrownianMotion(int c, double[] x0, double[] mu, double[] sigma, MultivariateBrownianMotion mbm) {
        this.mbm = mbm;
        this.setParams(c, x0, mu, sigma);
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        this.d = d;
        super.setObservationTimes(t, d);
        this.mbm.setObservationTimes(t, d);
    }

    public double[] nextObservationVector() {
        throw new UnsupportedOperationException("nextObservationVector is not implemented ");
    }

    @Override
    public void nextObservationVector(double[] obs) {
        throw new UnsupportedOperationException("nextObservationVector is not implemented ");
    }

    @Override
    public double[] generatePath() {
        for (int i = 0; i < this.c; ++i) {
            this.path[i] = this.x0[i];
        }
        this.mbm.generatePath();
        for (int j = 1; j <= this.d; ++j) {
            for (int i = 0; i < this.c; ++i) {
                this.path[this.c * j + i] = this.x0[i] * Math.exp(this.mbm.getObservation(j, i));
            }
        }
        this.observationCounter = this.d;
        return this.path;
    }

    @Override
    public void resetStartProcess() {
        this.observationCounter = 0;
        this.mbm.resetStartProcess();
    }

    public void setParams(int c, double[] x0, double[] mu, double[] sigma) {
        if (x0.length < c) {
            throw new IllegalArgumentException("x0 dimension :  " + x0.length + " is smaller than the process dimension : " + c);
        }
        if (mu.length < c) {
            throw new IllegalArgumentException("mu dimension :  " + mu.length + " is smaller than the process dimension : " + c);
        }
        if (sigma.length < c) {
            throw new IllegalArgumentException("sigma dimension :  " + sigma.length + " is smaller than the process dimension : " + c);
        }
        double[] zero = new double[c];
        this.c = c;
        this.x0 = x0;
        this.mu = new double[c];
        for (int i = 0; i < c; ++i) {
            this.mu[i] = mu[i] - 0.5 * sigma[i] * sigma[i];
            zero[i] = 0.0;
        }
        this.mbm.setParams(zero, this.mu, sigma);
        if (this.observationTimesSet) {
            this.init();
        }
    }

    @Override
    public void setStream(RandomStream stream) {
        this.mbm.gen.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.mbm.gen.getStream();
    }

    public NormalGen getGen() {
        return this.gen;
    }

    public MultivariateBrownianMotion getBrownianMotion() {
        return this.mbm;
    }

    @Override
    protected void init() {
        super.init();
    }
}

