/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.stochprocess.StochasticProcess;

public abstract class MultivariateStochasticProcess
extends StochasticProcess {
    protected double[] x0;
    protected int c = 1;

    @Override
    public abstract double[] generatePath();

    @Override
    public void getSubpath(double[] subpath, int[] pathIndices) {
        for (int j = 0; j < pathIndices.length; ++j) {
            for (int i = 0; i < this.c; ++i) {
                subpath[this.c * j + i] = this.path[this.c * pathIndices[j] + i];
            }
        }
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        if (d <= 0) {
            throw new IllegalArgumentException("Number of observation times d <= 0");
        }
        this.d = d;
        this.observationTimesSet = true;
        this.t = new double[d + 1];
        System.arraycopy(t, 0, this.t, 0, d + 1);
        for (int i = 0; i < d; ++i) {
            if (!(t[i + 1] < t[i])) continue;
            throw new IllegalArgumentException("Observation times t[] are not ordered chronologically");
        }
        this.init();
    }

    public void getObservation(int j, double[] obs) {
        for (int i = 0; i < this.c; ++i) {
            obs[i] = this.path[this.c * j + i];
        }
    }

    public double getObservation(int j, int i) {
        return this.path[this.c * j + i];
    }

    public abstract void nextObservationVector(double[] var1);

    public void getCurrentObservation(double[] obs) {
        for (int i = 0; i < this.c; ++i) {
            obs[i] = this.path[this.c * this.observationIndex + i];
        }
    }

    public double[] getX0(double[] x0) {
        for (int i = 0; i < this.c; ++i) {
            x0[i] = this.x0[i];
        }
        return x0;
    }

    @Override
    protected void init() {
        if (this.observationTimesSet) {
            this.createPath();
        }
        if (this.path != null) {
            for (int i = 0; i < this.c; ++i) {
                this.path[i] = this.x0[i];
            }
        }
    }

    protected void createPath() {
        this.path = new double[this.c * (this.d + 1)];
    }

    public int getDimension() {
        return this.c;
    }
}

