/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2019 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class TimeKeyExpression extends ASTNodeAccessImpl implements Expression {

    private String stringValue;

    public TimeKeyExpression() {
        // empty constructor
    }

    public TimeKeyExpression(final String value) {
        this.stringValue = value;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String getStringValue() {
        return stringValue;
    }

    public void setStringValue(String string) {
        stringValue = string;
    }

    @Override
    public String toString() {
        return getStringValue();
    }

    public TimeKeyExpression withStringValue(String stringValue) {
        this.setStringValue(stringValue);
        return this;
    }
}
