/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;

public final class CmisBindingsHelper {
    public static final String REPOSITORY_INFO_CACHE = "org.apache.chemistry.opencmis.binding.repositoryInfoCache";
    public static final String TYPE_DEFINTION_CACHE = "org.apache.chemistry.opencmis.binding.typeDefintionCache";
    public static final String SPI_OBJECT = "org.apache.chemistry.opencmis.binding.spi.object";
    public static final String HTTP_INVOKER_OBJECT = "org.apache.chemistry.opencmis.binding.httpinvoker.object";
    public static final String AUTHENTICATION_PROVIDER_OBJECT = "org.apache.chemistry.opencmis.binding.auth.object";
    public static final String ACCEPT_LANGUAGE = "org.apache.chemistry.opencmis.binding.acceptLanguage";
    public static final String FORCE_CMIS_VERSION = "org.apache.chemistry.opencmis.cmisversion";

    private CmisBindingsHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmisSpi getSPI(BindingSession session) {
        assert (session != null);
        CmisSpi spi = (CmisSpi)session.get(SPI_OBJECT);
        if (spi != null) {
            return spi;
        }
        session.writeLock();
        try {
            spi = (CmisSpi)session.get(SPI_OBJECT);
            if (spi != null) {
                CmisSpi cmisSpi = spi;
                return cmisSpi;
            }
            try {
                String spiName = (String)session.get("org.apache.chemistry.opencmis.binding.spi.classname");
                Constructor c = ClassLoaderUtil.loadClass((String)spiName).getConstructor(BindingSession.class);
                spi = (CmisSpi)c.newInstance(session);
            }
            catch (CmisBaseException e) {
                throw e;
            }
            catch (InvocationTargetException ite) {
                throw new CmisRuntimeException("SPI cannot be initialized: " + ite.getCause().getMessage(), (Throwable)ite);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("SPI cannot be initialized: " + e.getMessage(), (Throwable)e);
            }
            session.put(SPI_OBJECT, spi, true);
        }
        finally {
            session.writeUnlock();
        }
        assert (spi != null);
        return spi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpInvoker getHttpInvoker(BindingSession session) {
        assert (session != null);
        HttpInvoker invoker = (HttpInvoker)session.get(HTTP_INVOKER_OBJECT);
        if (invoker != null) {
            return invoker;
        }
        session.writeLock();
        try {
            invoker = (HttpInvoker)session.get(HTTP_INVOKER_OBJECT);
            if (invoker != null) {
                HttpInvoker httpInvoker = invoker;
                return httpInvoker;
            }
            try {
                String invokerName = (String)session.get("org.apache.chemistry.opencmis.binding.httpinvoker.classname");
                invoker = (HttpInvoker)ClassLoaderUtil.loadClass((String)invokerName).newInstance();
            }
            catch (CmisBaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CmisRuntimeException("HTTP invoker cannot be initialized: " + e.getMessage(), (Throwable)e);
            }
            session.put(HTTP_INVOKER_OBJECT, invoker, true);
        }
        finally {
            session.writeUnlock();
        }
        assert (invoker != null);
        return invoker;
    }

    public static CmisVersion getForcedCmisVersion(BindingSession session) {
        assert (session != null);
        return (CmisVersion)session.get(FORCE_CMIS_VERSION);
    }

    public static AuthenticationProvider getAuthenticationProvider(BindingSession session) {
        assert (session != null);
        return (AuthenticationProvider)session.get(AUTHENTICATION_PROVIDER_OBJECT);
    }

    public static RepositoryInfoCache getRepositoryInfoCache(BindingSession session) {
        assert (session != null);
        return (RepositoryInfoCache)session.get(REPOSITORY_INFO_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeDefinitionCache getTypeDefinitionCache(BindingSession session) {
        assert (session != null);
        TypeDefinitionCache cache = (TypeDefinitionCache)session.get(TYPE_DEFINTION_CACHE);
        if (cache != null) {
            return cache;
        }
        session.writeLock();
        try {
            cache = (TypeDefinitionCache)session.get(TYPE_DEFINTION_CACHE);
            if (cache != null) {
                TypeDefinitionCache typeDefinitionCache = cache;
                return typeDefinitionCache;
            }
            try {
                String cacheName = (String)session.get("org.apache.chemistry.opencmis.cache.types.classname");
                cache = (TypeDefinitionCache)ClassLoaderUtil.loadClass((String)cacheName).newInstance();
                cache.initialize(session);
            }
            catch (CmisBaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Type definition cache cannot be initialized: " + e.getMessage(), (Throwable)e);
            }
            session.put(TYPE_DEFINTION_CACHE, cache);
        }
        finally {
            session.writeUnlock();
        }
        assert (cache != null);
        return cache;
    }
}

