/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAuthenticationProvider.class);
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Token token = null;
    private long defaultTokenLifetime = 3600L;

    @Override
    public void setSession(BindingSession session) {
        super.setSession(session);
        if (this.token == null) {
            String accessToken = null;
            if (session.get("org.apache.chemistry.opencmis.oauth.accessToken") instanceof String) {
                accessToken = (String)session.get("org.apache.chemistry.opencmis.oauth.accessToken");
            }
            String refreshToken = null;
            if (session.get("org.apache.chemistry.opencmis.oauth.refreshToken") instanceof String) {
                refreshToken = (String)session.get("org.apache.chemistry.opencmis.oauth.refreshToken");
            }
            long expirationTimestamp = 0L;
            if (session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp") instanceof String) {
                try {
                    expirationTimestamp = Long.parseLong((String)session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp"));
                }
                catch (NumberFormatException nfe) {}
            } else if (session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp") instanceof Number) {
                expirationTimestamp = ((Number)session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp")).longValue();
            }
            if (session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime") instanceof String) {
                try {
                    this.defaultTokenLifetime = Long.parseLong((String)session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime"));
                }
                catch (NumberFormatException nfe) {}
            } else if (session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime") instanceof Number) {
                this.defaultTokenLifetime = ((Number)session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime")).longValue();
            }
            this.token = new Token(accessToken, refreshToken, expirationTimestamp);
        }
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        Map<String, List<String>> headers = super.getHTTPHeaders(url);
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
        }
        headers.put("Authorization", Collections.singletonList("Bearer " + this.getAccessToken()));
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken() {
        this.lock.readLock().lock();
        try {
            Token token = this.token;
            return token;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected boolean getSendBearerToken() {
        return false;
    }

    protected String getAccessToken() {
        this.lock.writeLock().lock();
        try {
            if (this.token.getAccessToken() == null) {
                if (this.token.getRefreshToken() == null) {
                    this.requestToken();
                } else {
                    this.refreshToken();
                }
            } else if (this.token.isExpired()) {
                this.refreshToken();
            }
            String string = this.token.getAccessToken();
            return string;
        }
        catch (CmisConnectionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot get OAuth access token: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void requestToken() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting new OAuth access token.");
        }
        this.makeRequest(false);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.token.toString());
        }
    }

    private void refreshToken() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Refreshing OAuth access token.");
        }
        this.makeRequest(true);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.token.toString());
        }
    }

    private void makeRequest(boolean isRefresh) throws IOException {
        Object clientSecret;
        Object tokenEndpoint = this.getSession().get("org.apache.chemistry.opencmis.oauth.tokenEndpoint");
        if (!(tokenEndpoint instanceof String)) {
            throw new CmisConnectionException("Token endpoint not set!");
        }
        if (isRefresh && this.token.getRefreshToken() == null) {
            throw new CmisConnectionException("No refresh token!");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(tokenEndpoint.toString()).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", ClientVersion.OPENCMIS_CLIENT);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        if (isRefresh) {
            writer.write("grant_type=refresh_token");
            writer.write("&refresh_token=");
            writer.write(IOUtils.encodeURL((String)this.token.getRefreshToken()));
        } else {
            Object redirectUri;
            writer.write("grant_type=authorization_code");
            Object code = this.getSession().get("org.apache.chemistry.opencmis.oauth.code");
            if (code != null) {
                writer.write("&code=");
                writer.write(IOUtils.encodeURL((String)code.toString()));
            }
            if ((redirectUri = this.getSession().get("org.apache.chemistry.opencmis.oauth.redirectUri")) != null) {
                writer.write("&redirect_uri=");
                writer.write(IOUtils.encodeURL((String)redirectUri.toString()));
            }
        }
        Object clientId = this.getSession().get("org.apache.chemistry.opencmis.oauth.clientId");
        if (clientId != null) {
            writer.write("&client_id=");
            writer.write(IOUtils.encodeURL((String)clientId.toString()));
        }
        if ((clientSecret = this.getSession().get("org.apache.chemistry.opencmis.oauth.clientSecret")) != null) {
            writer.write("&client_secret=");
            writer.write(IOUtils.encodeURL((String)clientSecret.toString()));
        }
        ((Writer)writer).flush();
        conn.connect();
        if (conn.getResponseCode() != 200) {
            JSONObject jsonResponse = this.parseResponse(conn);
            Object error = jsonResponse.get((Object)"error");
            Object description = jsonResponse.get((Object)"error_description");
            if (LOG.isDebugEnabled()) {
                LOG.debug("OAuth token request failed: {}", (Object)jsonResponse.toJSONString());
            }
            throw new CmisConnectionException("OAuth token request failed" + (error == null ? "" : ": " + error) + (description == null ? "" : ": " + description));
        }
        JSONObject jsonResponse = this.parseResponse(conn);
        Object tokenType = jsonResponse.get((Object)"token_type");
        if (!(tokenType instanceof String) || !"bearer".equalsIgnoreCase((String)tokenType)) {
            throw new CmisConnectionException("Unsupported OAuth token type: " + tokenType);
        }
        Object jsonAccessToken = jsonResponse.get((Object)"access_token");
        if (!(jsonAccessToken instanceof String)) {
            throw new CmisConnectionException("Invalid OAuth access_token!");
        }
        Object jsonRefreshToken = jsonResponse.get((Object)"refresh_token");
        if (jsonRefreshToken != null && !(jsonRefreshToken instanceof String)) {
            throw new CmisConnectionException("Invalid OAuth refresh_token!");
        }
        long expiresIn = this.defaultTokenLifetime;
        Object jsonExpiresIn = jsonResponse.get((Object)"expires_in");
        if (jsonExpiresIn != null) {
            if (jsonExpiresIn instanceof Number) {
                expiresIn = ((Number)jsonExpiresIn).longValue();
            } else if (jsonExpiresIn instanceof String) {
                try {
                    expiresIn = Long.parseLong((String)jsonExpiresIn);
                }
                catch (NumberFormatException nfe) {
                    throw new CmisConnectionException("Invalid OAuth expires_in value!");
                }
            } else {
                throw new CmisConnectionException("Invalid OAuth expires_in value!");
            }
        }
        this.token = new Token(jsonAccessToken.toString(), jsonRefreshToken == null ? null : jsonRefreshToken.toString(), expiresIn * 1000L + System.currentTimeMillis());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject parseResponse(HttpURLConnection conn) {
        JSONObject jSONObject;
        InputStreamReader reader = null;
        try {
            InputStream stream = null;
            int respCode = conn.getResponseCode();
            stream = respCode >= 200 && respCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            if (stream == null) {
                throw new CmisConnectionException("Invalid OAuth token response!");
            }
            JSONParser parser = new JSONParser();
            reader = new InputStreamReader(stream, this.extractCharset(conn));
            Object response = parser.parse((Reader)reader);
            if (!(response instanceof JSONObject)) {
                throw new CmisConnectionException("Invalid OAuth token response!");
            }
            jSONObject = (JSONObject)response;
        }
        catch (CmisConnectionException ce) {
            try {
                throw ce;
                catch (Exception pe) {
                    throw new CmisConnectionException("Parsing the OAuth token response failed: " + pe.getMessage(), (Throwable)pe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.consumeAndClose(reader);
                throw throwable;
            }
        }
        IOUtils.consumeAndClose((Reader)reader);
        return jSONObject;
    }

    private String extractCharset(HttpURLConnection conn) {
        String charset = "UTF-8";
        String contentType = conn.getContentType();
        if (contentType != null) {
            String[] parts = contentType.split(";");
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim().toLowerCase(Locale.ENGLISH);
                if (!part.startsWith("charset")) continue;
                int x = part.indexOf(61);
                charset = part.substring(x + 1).trim();
                break;
            }
        }
        return charset;
    }

    public static class Token {
        private String accessToken;
        private String refreshToken;
        private long expirationTimestamp;

        public Token(String accessToken, String refreshToken, long expirationTimestamp) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expirationTimestamp = expirationTimestamp;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public long getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expirationTimestamp;
        }

        public String toString() {
            return "Access token: " + this.accessToken + " / Refresh token: " + this.refreshToken + " / Expires : " + this.expirationTimestamp;
        }
    }
}

