/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.color;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.VertexColoringAlgorithm;

public class ColorRefinementAlgorithm<V, E>
implements VertexColoringAlgorithm<V> {
    private final Graph<V, E> graph;
    private final VertexColoringAlgorithm.Coloring<V> alpha;

    public ColorRefinementAlgorithm(Graph<V, E> graph, VertexColoringAlgorithm.Coloring<V> alpha) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        this.alpha = Objects.requireNonNull(alpha, "alpha cannot be null");
        if (!this.isAlphaConsistent(alpha, graph)) {
            throw new IllegalArgumentException("alpha is not a valid surjective l-coloring for the given graph.");
        }
    }

    public ColorRefinementAlgorithm(Graph<V, E> graph) {
        this(graph, ColorRefinementAlgorithm.getDefaultAlpha(graph.vertexSet()));
    }

    @Override
    public VertexColoringAlgorithm.Coloring<V> getColoring() {
        ColoringRepresentation rep = new ColoringRepresentation(this.graph, this.alpha);
        Deque<Integer> refineStack = this.getSortedStack(this.alpha);
        while (!refineStack.isEmpty()) {
            Integer currentColor = refineStack.pop();
            Set<Integer> adjacentColors = this.calculateColorDegrees(currentColor, rep);
            adjacentColors.stream().filter(c -> rep.minColorDegree[c] < rep.maxColorDegree[c]).sorted(Comparator.comparingInt(o -> o)).forEach(color -> this.splitUpColor((Integer)color, refineStack, rep));
            this.cleanupColorDegrees(adjacentColors, rep);
        }
        return new VertexColoringAlgorithm.ColoringImpl(rep.coloring, rep.coloring.size());
    }

    private Set<Integer> calculateColorDegrees(int refiningColor, ColoringRepresentation rep) {
        int n = this.graph.vertexSet().size();
        LinkedHashSet<Integer> adjacentColors = new LinkedHashSet<Integer>(n);
        for (Object v : rep.colorClasses.get(refiningColor)) {
            Set inNeighborhood = this.graph.incomingEdgesOf(v).stream().map(e -> Graphs.getOppositeVertex(this.graph, e, v)).collect(Collectors.toSet());
            for (Object w : inNeighborhood) {
                rep.colorDegree.put((Integer)w, rep.colorDegree.get(w) + 1);
                if (rep.colorDegree.get(w) == 1) {
                    rep.positiveDegreeColorClasses.get(rep.coloring.get(w)).add(w);
                }
                adjacentColors.add(rep.coloring.get(w));
                if (rep.colorDegree.get(w) <= rep.maxColorDegree[rep.coloring.get(w)]) continue;
                rep.maxColorDegree[rep.coloring.get(w).intValue()] = rep.colorDegree.get(w);
            }
        }
        for (Integer c : adjacentColors) {
            if (rep.colorClasses.get(c).size() != rep.positiveDegreeColorClasses.get(c).size()) {
                rep.minColorDegree[c.intValue()] = 0;
                continue;
            }
            rep.minColorDegree[c.intValue()] = rep.maxColorDegree[c];
            for (Object v : rep.positiveDegreeColorClasses.get(c)) {
                if (rep.colorDegree.get(v) >= rep.minColorDegree[c]) continue;
                rep.minColorDegree[c.intValue()] = rep.colorDegree.get(v);
            }
        }
        return adjacentColors;
    }

    private void cleanupColorDegrees(Set<Integer> adjacentColors, ColoringRepresentation rep) {
        for (int c : adjacentColors) {
            for (Object v : rep.positiveDegreeColorClasses.get(c)) {
                rep.colorDegree.put((Integer)v, 0);
            }
            rep.maxColorDegree[c] = 0;
            rep.positiveDegreeColorClasses.put(c, new ArrayList());
        }
    }

    private void splitUpColor(Integer color, Deque<Integer> refineStack, ColoringRepresentation rep) {
        HashMap<Integer, Integer> numColorDegree = new HashMap<Integer, Integer>();
        for (int i = 1; i <= rep.maxColorDegree[color]; ++i) {
            numColorDegree.put(i, 0);
        }
        numColorDegree.put(0, rep.colorClasses.get(color).size() - rep.positiveDegreeColorClasses.get(color).size());
        for (Object v : rep.positiveDegreeColorClasses.get(color)) {
            numColorDegree.put(rep.colorDegree.get(v), (Integer)numColorDegree.get(rep.colorDegree.get(v)) + 1);
        }
        int maxColorDegreeIndex = 0;
        for (int i = 1; i <= rep.maxColorDegree[color]; ++i) {
            if ((Integer)numColorDegree.get(i) <= (Integer)numColorDegree.get(maxColorDegreeIndex)) continue;
            maxColorDegreeIndex = i;
        }
        HashMap<Integer, Integer> newMapping = new HashMap<Integer, Integer>();
        boolean isCurrentColorInStack = refineStack.contains(color);
        int currentMaxColorDegree = rep.maxColorDegree[color];
        for (int i = 0; i <= currentMaxColorDegree; ++i) {
            if ((Integer)numColorDegree.get(i) < 1) continue;
            if (i == rep.minColorDegree[color]) {
                newMapping.put(i, color);
                if (isCurrentColorInStack || maxColorDegreeIndex == i) continue;
                refineStack.push((Integer)newMapping.get(i));
                continue;
            }
            newMapping.put(i, ++rep.lastUsedColor);
            if (!isCurrentColorInStack && i == maxColorDegreeIndex) continue;
            refineStack.push((Integer)newMapping.get(i));
        }
        for (Object v : rep.positiveDegreeColorClasses.get(color)) {
            if (((Integer)newMapping.get(rep.colorDegree.get(v))).equals(color)) continue;
            rep.colorClasses.get(color).remove(v);
            rep.colorClasses.get(newMapping.get(rep.colorDegree.get(v))).add(v);
            rep.coloring.replace(v, (Integer)newMapping.get(rep.colorDegree.get(v)));
        }
    }

    private boolean isAlphaConsistent(VertexColoringAlgorithm.Coloring<V> alpha, Graph<V, E> graph) {
        if (alpha.getColors().size() != graph.vertexSet().size()) {
            return false;
        }
        if (alpha.getColorClasses().size() != alpha.getNumberColors()) {
            return false;
        }
        for (V v : graph.vertexSet()) {
            if (!alpha.getColors().containsKey(v)) {
                return false;
            }
            Integer currentColor = alpha.getColors().get(v);
            if (currentColor + 1 <= alpha.getNumberColors() && currentColor >= 0) continue;
            return false;
        }
        return true;
    }

    private static <V> VertexColoringAlgorithm.Coloring<V> getDefaultAlpha(Set<V> vertices) {
        HashMap<V, Integer> alpha = new HashMap<V, Integer>();
        for (V v : vertices) {
            alpha.put(v, 0);
        }
        return new VertexColoringAlgorithm.ColoringImpl(alpha, 1);
    }

    private Deque<Integer> getSortedStack(VertexColoringAlgorithm.Coloring<V> alpha) {
        int numberColors = alpha.getNumberColors();
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>(this.graph.vertexSet().size());
        for (int i = numberColors - 1; i >= 0; --i) {
            stack.push(i);
        }
        return stack;
    }

    private class ColoringRepresentation {
        HashMap<Integer, List<V>> colorClasses;
        HashMap<Integer, List<V>> positiveDegreeColorClasses;
        int[] maxColorDegree;
        int[] minColorDegree;
        Map<V, Integer> colorDegree;
        Map<V, Integer> coloring;
        int lastUsedColor;

        public ColoringRepresentation(Graph<V, E> graph, VertexColoringAlgorithm.Coloring<V> alpha) {
            int n = graph.vertexSet().size();
            this.colorClasses = new HashMap(n);
            this.positiveDegreeColorClasses = new HashMap(n);
            this.maxColorDegree = new int[n];
            this.minColorDegree = new int[n];
            this.colorDegree = new HashMap();
            this.coloring = new HashMap();
            for (int c = 0; c < n; ++c) {
                this.colorClasses.put(c, new ArrayList());
                this.positiveDegreeColorClasses.put(c, new ArrayList());
            }
            for (Object v : graph.vertexSet()) {
                this.colorClasses.get(alpha.getColors().get(v)).add(v);
                this.colorDegree.put((Integer)v, 0);
                this.coloring.put((Integer)v, alpha.getColors().get(v));
            }
            this.lastUsedColor = alpha.getNumberColors() - 1;
        }
    }
}

