/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public final class BidirectionalDijkstraShortestPath<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private double radius;

    public BidirectionalDijkstraShortestPath(Graph<V, E> graph) {
        this(graph, Double.POSITIVE_INFINITY);
    }

    public BidirectionalDijkstraShortestPath(Graph<V, E> graph, double radius) {
        super(graph);
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.radius = radius;
    }

    @Override
    public GraphPath<V, E> getPath(V source, V sink) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        if (source.equals(sink)) {
            return this.createEmptyPath(source, sink);
        }
        SearchFrontier forwardFrontier = new SearchFrontier(this.graph);
        SearchFrontier backwardFrontier = this.graph.getType().isDirected() ? new SearchFrontier(new EdgeReversedGraph(this.graph)) : new SearchFrontier(this.graph);
        assert (!source.equals(sink));
        forwardFrontier.updateDistance(source, null, 0.0);
        backwardFrontier.updateDistance(sink, null, 0.0);
        double bestPath = Double.POSITIVE_INFINITY;
        V bestPathCommonVertex = null;
        SearchFrontier frontier = forwardFrontier;
        SearchFrontier otherFrontier = backwardFrontier;
        while (!(frontier.heap.isEmpty() || otherFrontier.heap.isEmpty() || frontier.heap.min().getKey() + otherFrontier.heap.min().getKey() >= bestPath)) {
            FibonacciHeapNode<QueueEntry> node = frontier.heap.removeMin();
            Object v = node.getData().v;
            double vDistance = node.getKey();
            for (Object e : frontier.graph.outgoingEdgesOf(v)) {
                Object u = Graphs.getOppositeVertex(frontier.graph, e, v);
                double eWeight = frontier.graph.getEdgeWeight(e);
                frontier.updateDistance(u, e, vDistance + eWeight);
                double pathDistance = vDistance + eWeight + otherFrontier.getDistance(u);
                if (!(pathDistance < bestPath)) continue;
                bestPath = pathDistance;
                bestPathCommonVertex = u;
            }
            SearchFrontier tmpFrontier = frontier;
            frontier = otherFrontier;
            otherFrontier = tmpFrontier;
        }
        if (Double.isFinite(bestPath) && bestPath <= this.radius) {
            return this.createPath(forwardFrontier, backwardFrontier, bestPath, source, bestPathCommonVertex, sink);
        }
        return this.createEmptyPath(source, sink);
    }

    public static <V, E> GraphPath<V, E> findPathBetween(Graph<V, E> graph, V source, V sink) {
        return new BidirectionalDijkstraShortestPath<V, E>(graph).getPath(source, sink);
    }

    private GraphPath<V, E> createPath(SearchFrontier forwardFrontier, SearchFrontier backwardFrontier, double weight, V source, V commonVertex, V sink) {
        Object e;
        LinkedList edgeList = new LinkedList();
        LinkedList<V> vertexList = new LinkedList<V>();
        vertexList.add(commonVertex);
        V v = commonVertex;
        while ((e = forwardFrontier.getTreeEdge(v)) != null) {
            edgeList.addFirst(e);
            v = Graphs.getOppositeVertex(forwardFrontier.graph, e, v);
            vertexList.addFirst(v);
        }
        v = commonVertex;
        while ((e = backwardFrontier.getTreeEdge(v)) != null) {
            edgeList.addLast(e);
            v = Graphs.getOppositeVertex(backwardFrontier.graph, e, v);
            vertexList.addLast(v);
        }
        return new GraphWalk(this.graph, source, sink, vertexList, edgeList, weight);
    }

    class QueueEntry {
        E e;
        V v;

        public QueueEntry(E e, V v) {
            this.e = e;
            this.v = v;
        }
    }

    class SearchFrontier {
        final Graph<V, E> graph;
        final FibonacciHeap<QueueEntry> heap;
        final Map<V, FibonacciHeapNode<QueueEntry>> seen;

        public SearchFrontier(Graph<V, E> graph) {
            this.graph = graph;
            this.heap = new FibonacciHeap();
            this.seen = new HashMap();
        }

        public void updateDistance(V v, E e, double distance) {
            FibonacciHeapNode<QueueEntry> node = this.seen.get(v);
            if (node == null) {
                node = new FibonacciHeapNode<QueueEntry>(new QueueEntry(e, v));
                this.heap.insert(node, distance);
                this.seen.put((FibonacciHeapNode<QueueEntry>)v, node);
            } else if (distance < node.getKey()) {
                this.heap.decreaseKey(node, distance);
                node.getData().e = e;
            }
        }

        public double getDistance(V v) {
            FibonacciHeapNode<QueueEntry> node = this.seen.get(v);
            if (node == null) {
                return Double.POSITIVE_INFINITY;
            }
            return node.getKey();
        }

        public E getTreeEdge(V v) {
            FibonacciHeapNode<QueueEntry> node = this.seen.get(v);
            if (node == null) {
                return null;
            }
            return node.getData().e;
        }
    }
}

