/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import javax.annotation.Nonnull;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.util.ByteVector;

final class InterfaceWriter
extends AttributeWriter {
    @Nonnull
    private final int[] interfaceItemIndices;

    InterfaceWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String[] interfaceNames) {
        super(cp);
        int n = interfaceNames.length;
        int[] cpItemIndices = new int[n];
        for (int i = 0; i < n; ++i) {
            cpItemIndices[i] = cp.newClass(interfaceNames[i]);
        }
        this.interfaceItemIndices = cpItemIndices;
    }

    @Override
    public int getSize() {
        return 2 * this.interfaceItemIndices.length;
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        out.putShort(this.interfaceItemIndices.length);
        for (int interfaceItemIndex : this.interfaceItemIndices) {
            out.putShort(interfaceItemIndex);
        }
    }
}

