/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.controlFlow;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.constantPool.UninitializedTypeTableItem;
import mockit.asm.controlFlow.Frame;
import mockit.asm.types.JavaType;
import mockit.asm.util.ByteVector;

public final class StackMapTableWriter
extends AttributeWriter {
    private final boolean java6OrNewer;
    @Nonnegative
    private int maxStack;
    @Nonnegative
    private int maxLocals;
    @Nonnegative
    private int frameCount;
    private ByteVector stackMap;
    private int[] previousFrame;
    private int[] frameDefinition;
    @Nonnegative
    private int frameIndex;

    public StackMapTableWriter(@Nonnull ConstantPoolGeneration cp, boolean java6OrNewer, int methodAccess, @Nonnull String methodDesc) {
        super(cp);
        this.java6OrNewer = java6OrNewer;
        int size = JavaType.getArgumentsAndReturnSizes(methodDesc) >> 2;
        if ((methodAccess & 8) != 0) {
            --size;
        }
        this.maxLocals = size;
    }

    public void setMaxStack(@Nonnegative int maxStack) {
        this.maxStack = maxStack;
    }

    public void updateMaxLocals(@Nonnegative int n) {
        if (n > this.maxLocals) {
            this.maxLocals = n;
        }
    }

    public void putMaxStackAndLocals(@Nonnull ByteVector out) {
        out.putShort(this.maxStack).putShort(this.maxLocals);
    }

    @Nonnegative
    private int getInstructionOffset() {
        return this.frameDefinition[0];
    }

    private void setInstructionOffset(@Nonnegative int offset) {
        this.frameDefinition[0] = offset;
    }

    @Nonnegative
    private int getNumLocals() {
        return this.frameDefinition[1];
    }

    private void setNumLocals(@Nonnegative int numLocals) {
        this.frameDefinition[1] = numLocals;
    }

    @Nonnegative
    private int getStackSize() {
        return this.frameDefinition[2];
    }

    private void setStackSize(@Nonnegative int stackSize) {
        this.frameDefinition[2] = stackSize;
    }

    private void writeFrameDefinition(@Nonnegative int value) {
        this.frameDefinition[this.frameIndex++] = value;
    }

    public boolean hasStackMap() {
        return this.stackMap != null;
    }

    private void startFrame(@Nonnegative int offset, @Nonnegative int nLocals, @Nonnegative int nStack) {
        int n = 3 + nLocals + nStack;
        if (this.frameDefinition == null || this.frameDefinition.length < n) {
            this.frameDefinition = new int[n];
        }
        this.setInstructionOffset(offset);
        this.setNumLocals(nLocals);
        this.setStackSize(nStack);
        this.frameIndex = 3;
    }

    private void endFrame() {
        if (this.previousFrame != null) {
            if (this.stackMap == null) {
                this.setAttribute(this.java6OrNewer ? "StackMapTable" : "StackMap");
                this.stackMap = new ByteVector();
            }
            this.writeFrame();
            ++this.frameCount;
        }
        this.previousFrame = this.frameDefinition;
        this.frameDefinition = null;
    }

    private void writeFrame() {
        int currentLocalsSize = this.getNumLocals();
        int currentStackSize = this.getStackSize();
        if (this.java6OrNewer) {
            this.writeFrameForJava6OrNewer(currentLocalsSize, currentStackSize);
        } else {
            this.writeFrameForOldVersionOfJava(currentLocalsSize, currentStackSize);
        }
    }

    private void writeFrameForOldVersionOfJava(@Nonnegative int localsSize, @Nonnegative int stackSize) {
        int instructionOffset = this.getInstructionOffset();
        this.writeFrame(instructionOffset, localsSize, stackSize);
    }

    private void writeFullFrame(@Nonnegative int instructionOffset, @Nonnegative int localsSize, @Nonnegative int stackSize) {
        this.stackMap.putByte(255);
        this.writeFrame(instructionOffset, localsSize, stackSize);
    }

    private void writeFrame(@Nonnegative int instructionOffset, @Nonnegative int localsSize, @Nonnegative int stackSize) {
        this.stackMap.putShort(instructionOffset);
        this.stackMap.putShort(localsSize);
        int lastTypeIndex = 3 + localsSize;
        this.writeFrameTypes(3, lastTypeIndex);
        this.stackMap.putShort(stackSize);
        this.writeFrameTypes(lastTypeIndex, lastTypeIndex + stackSize);
    }

    private void writeFrameForJava6OrNewer(@Nonnegative int currentLocalsSize, @Nonnegative int currentStackSize) {
        int delta;
        int previousLocalsSize = this.previousFrame[1];
        int k = currentStackSize == 0 ? currentLocalsSize - previousLocalsSize : 0;
        int type = StackMapTableWriter.selectFrameType(currentLocalsSize, currentStackSize, previousLocalsSize, k, delta = this.getDelta());
        if (type == 248) {
            previousLocalsSize = currentLocalsSize;
        }
        type = this.selectFullFrameIfLocalsAreNotTheSame(previousLocalsSize, type);
        switch (type) {
            case 0: {
                this.stackMap.putByte(delta);
                break;
            }
            case 64: {
                this.writeFrameWithSameLocalsAndOneStackItem(currentLocalsSize, delta);
                break;
            }
            case 247: {
                this.writeExtendedFrameWithSameLocalsAndOneStackItem(currentLocalsSize, delta);
                break;
            }
            case 251: {
                this.writeFrameWithSameLocalsAndZeroStackItems(0, delta);
                break;
            }
            case 248: {
                this.writeFrameWithSameLocalsAndZeroStackItems(k, delta);
                break;
            }
            case 252: {
                this.writeAppendedFrame(currentLocalsSize, previousLocalsSize, k, delta);
                break;
            }
            default: {
                this.writeFullFrame(delta, currentLocalsSize, currentStackSize);
            }
        }
    }

    @Nonnegative
    private int getDelta() {
        int offset = this.getInstructionOffset();
        return this.frameCount == 0 ? offset : offset - this.previousFrame[0] - 1;
    }

    @Nonnegative
    private static int selectFrameType(@Nonnegative int currentLocalsSize, @Nonnegative int currentStackSize, @Nonnegative int previousLocalsSize, int k, @Nonnegative int delta) {
        int type = 255;
        if (currentStackSize == 0) {
            if (k == 0) {
                type = delta < 64 ? 0 : 251;
            } else if (k > 0) {
                if (k <= 3) {
                    type = 252;
                }
            } else if (k >= -3) {
                type = 248;
            }
        } else if (currentLocalsSize == previousLocalsSize && currentStackSize == 1) {
            type = delta < 63 ? 64 : 247;
        }
        return type;
    }

    @Nonnegative
    private int selectFullFrameIfLocalsAreNotTheSame(@Nonnegative int previousLocalsSize, @Nonnegative int type) {
        if (type != 255) {
            int l = 3;
            for (int j = 0; j < previousLocalsSize; ++j) {
                if (this.frameDefinition[l] != this.previousFrame[l]) {
                    return 255;
                }
                ++l;
            }
        }
        return type;
    }

    private void writeFrameWithSameLocalsAndOneStackItem(@Nonnegative int localsSize, @Nonnegative int delta) {
        this.stackMap.putByte(64 + delta);
        this.writeFrameTypes(3 + localsSize, 4 + localsSize);
    }

    private void writeFrameWithSameLocalsAndZeroStackItems(int k, @Nonnegative int delta) {
        this.stackMap.putByte(251 + k).putShort(delta);
    }

    private void writeExtendedFrameWithSameLocalsAndOneStackItem(@Nonnegative int localsSize, @Nonnegative int delta) {
        this.stackMap.putByte(247).putShort(delta);
        this.writeFrameTypes(3 + localsSize, 4 + localsSize);
    }

    private void writeAppendedFrame(@Nonnegative int currentLocalsSize, @Nonnegative int previousLocalsSize, int k, @Nonnegative int delta) {
        this.stackMap.putByte(251 + k).putShort(delta);
        this.writeFrameTypes(3 + previousLocalsSize, 3 + currentLocalsSize);
    }

    private void writeFrameTypes(@Nonnegative int start, @Nonnegative int end) {
        for (int i = start; i < end; ++i) {
            int type = this.frameDefinition[i];
            int dimensions = type & 0xF0000000;
            if (dimensions == 0) {
                this.writeFrameOfRegularType(type);
                continue;
            }
            this.writeFrameOfArrayType(dimensions, type);
        }
    }

    private void writeFrameOfRegularType(@Nonnegative int type) {
        int typeTableIndex = type & 0xFFFFF;
        switch (type & 0xFF00000) {
            case 0x1700000: {
                String classDesc = this.cp.getInternalName(typeTableIndex);
                int classDescIndex = this.cp.newClass(classDesc);
                this.stackMap.putByte(7).putShort(classDescIndex);
                break;
            }
            case 0x1800000: {
                UninitializedTypeTableItem uninitializedItemValue = this.cp.getUninitializedItemValue(typeTableIndex);
                int typeDesc = uninitializedItemValue.getOffset();
                this.stackMap.putByte(8).putShort(typeDesc);
                break;
            }
            default: {
                this.stackMap.putByte(typeTableIndex);
            }
        }
    }

    private void writeFrameOfArrayType(@Nonnegative int arrayDimensions, @Nonnegative int arrayElementType) {
        String arrayElementTypeDesc;
        StringBuilder sb = new StringBuilder();
        StackMapTableWriter.writeDimensionsIntoArrayDescriptor(sb, arrayDimensions);
        if ((arrayElementType & 0xFF00000) == 0x1700000) {
            arrayElementTypeDesc = this.cp.getInternalName(arrayElementType & 0xFFFFF);
            sb.append('L').append(arrayElementTypeDesc).append(';');
        } else {
            char typeCode = StackMapTableWriter.getTypeCodeForArrayElements(arrayElementType);
            sb.append(typeCode);
        }
        arrayElementTypeDesc = sb.toString();
        int typeDescIndex = this.cp.newClass(arrayElementTypeDesc);
        this.stackMap.putByte(7).putShort(typeDescIndex);
    }

    private static void writeDimensionsIntoArrayDescriptor(@Nonnull StringBuilder sb, @Nonnegative int arrayDimensions) {
        arrayDimensions >>= 28;
        while (arrayDimensions-- > 0) {
            sb.append('[');
        }
    }

    private static char getTypeCodeForArrayElements(@Nonnegative int arrayElementType) {
        switch (arrayElementType & 0xF) {
            case 1: {
                return 'I';
            }
            case 2: {
                return 'F';
            }
            case 3: {
                return 'D';
            }
            case 9: {
                return 'Z';
            }
            case 10: {
                return 'B';
            }
            case 11: {
                return 'C';
            }
            case 12: {
                return 'S';
            }
        }
        return 'J';
    }

    public void createAndVisitFirstFrame(@Nonnull Frame frame, @Nonnull String classDesc, @Nonnull String methodDesc, int methodAccess) {
        JavaType[] args = JavaType.getArgumentTypes(methodDesc);
        frame.initInputFrame(classDesc, methodAccess, args, this.maxLocals);
        this.visitFrame(frame);
    }

    public void visitFrame(@Nonnull Frame frame) {
        int[] locals = frame.inputLocals;
        int nLocal = StackMapTableWriter.computeNumberOfLocals(locals);
        int[] stacks = frame.inputStack;
        int nStack = StackMapTableWriter.computeStackSize(stacks);
        this.startFrame(frame.owner.position, nLocal, nStack);
        this.putLocalsOrStackElements(locals, nLocal);
        this.putLocalsOrStackElements(stacks, nStack);
        this.endFrame();
    }

    @Nonnegative
    private static int computeNumberOfLocals(@Nonnull int[] locals) {
        int nLocal = 0;
        int nTop = 0;
        for (int i = 0; i < locals.length; ++i) {
            int t = locals[i];
            if (t == 0x1000000) {
                ++nTop;
            } else {
                nLocal += nTop + 1;
                nTop = 0;
            }
            if (t != 0x1000004 && t != 0x1000003) continue;
            ++i;
        }
        return nLocal;
    }

    @Nonnegative
    private static int computeStackSize(@Nonnull int[] stacks) {
        int nStack = 0;
        for (int i = 0; i < stacks.length; ++i) {
            int t = stacks[i];
            ++nStack;
            if (t != 0x1000004 && t != 0x1000003) continue;
            ++i;
        }
        return nStack;
    }

    private void putLocalsOrStackElements(@Nonnull int[] itemIndices, @Nonnegative int nItems) {
        int i = 0;
        while (nItems > 0) {
            int itemType = itemIndices[i];
            this.writeFrameDefinition(itemType);
            if (itemType == 0x1000004 || itemType == 0x1000003) {
                ++i;
            }
            ++i;
            --nItems;
        }
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.stackMap == null ? 0 : 8 + this.stackMap.getLength();
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        if (this.stackMap != null) {
            this.put(out, 2 + this.stackMap.getLength());
            out.putShort(this.frameCount);
            out.putByteVector(this.stackMap);
        }
    }

    static interface LocalsAndStackItemsDiff {
        public static final int SAME_FRAME = 0;
        public static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
        public static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
        public static final int CHOP_FRAME = 248;
        public static final int SAME_FRAME_EXTENDED = 251;
        public static final int APPEND_FRAME = 252;
        public static final int FULL_FRAME = 255;
    }
}

