/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.exceptionHandling;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.controlFlow.Label;
import mockit.asm.util.ByteVector;

final class ExceptionHandler {
    @Nonnull
    final Label start;
    @Nonnull
    final Label end;
    @Nonnull
    final Label handler;
    @Nullable
    private final String desc;
    @Nonnegative
    private final int type;

    ExceptionHandler(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String desc, @Nonnegative int type) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.desc = desc;
        this.type = type;
    }

    @Nonnull
    String getCatchTypeDesc() {
        return this.desc == null ? "java/lang/Throwable" : this.desc;
    }

    void put(@Nonnull ByteVector out) {
        out.putShort(this.start.position).putShort(this.end.position).putShort(this.handler.position).putShort(this.type);
    }
}

