/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.exceptionHandling;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.controlFlow.Edge;
import mockit.asm.controlFlow.Label;
import mockit.asm.exceptionHandling.ExceptionHandler;
import mockit.asm.util.ByteVector;

public final class ExceptionHandling {
    @Nonnull
    private final List<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();
    @Nonnull
    private final ConstantPoolGeneration cp;

    public ExceptionHandling(@Nonnull ConstantPoolGeneration cp) {
        this.cp = cp;
    }

    public void addHandler(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
        int handlerType = type == null ? 0 : this.cp.newClass(type);
        this.handlers.add(new ExceptionHandler(start, end, handler, type, handlerType));
    }

    public void completeControlFlowGraphWithExceptionHandlerBlocksFromComputedFrames() {
        for (ExceptionHandler exceptionHandler : this.handlers) {
            Label handler = exceptionHandler.handler.getFirst();
            Label start = exceptionHandler.start.getFirst();
            Label end = exceptionHandler.end.getFirst();
            String catchType = exceptionHandler.getCatchTypeDesc();
            int kindOfEdge = 0x1700000 | this.cp.addNormalType(catchType);
            handler.markAsTarget();
            ExceptionHandling.addHandlerLabelAsSuccessor(kindOfEdge, handler, start, end);
        }
    }

    public void completeControlFlowGraphWithExceptionHandlerBlocks() {
        for (ExceptionHandler exceptionHandler : this.handlers) {
            ExceptionHandling.addHandlerLabelAsSuccessor(Integer.MAX_VALUE, exceptionHandler.handler, exceptionHandler.start, exceptionHandler.end);
        }
    }

    private static void addHandlerLabelAsSuccessor(int kindOfEdge, @Nonnull Label handler, @Nonnull Label start, @Nonnull Label end) {
        while (start != end) {
            Edge edge = new Edge(kindOfEdge, handler);
            start = start.setSuccessors(edge);
        }
    }

    public boolean hasHandlers() {
        return !this.handlers.isEmpty();
    }

    @Nonnegative
    public int getSize() {
        return 8 * this.handlers.size();
    }

    public void put(@Nonnull ByteVector out) {
        out.putShort(this.handlers.size());
        for (ExceptionHandler exceptionHandler : this.handlers) {
            exceptionHandler.put(out);
        }
    }
}

