/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.reflect.Modifier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassWriter;
import mockit.asm.classes.WrappingClassVisitor;
import mockit.asm.controlFlow.Label;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.asm.methods.WrappingMethodVisitor;
import mockit.asm.types.ArrayType;
import mockit.asm.types.JavaType;
import mockit.asm.types.ObjectType;
import mockit.asm.types.PrimitiveType;
import mockit.asm.types.ReferenceType;
import mockit.internal.ClassLoadingBridge;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.TypeConversion;

public class BaseClassModifier
extends WrappingClassVisitor {
    private static final int METHOD_ACCESS_MASK = 64255;
    protected static final JavaType VOID_TYPE = ObjectType.create("java/lang/Void");
    @Nonnull
    protected final MethodVisitor methodAnnotationsVisitor = new MethodVisitor(){

        @Override
        public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
            return BaseClassModifier.this.mw.visitAnnotation(desc);
        }
    };
    protected MethodWriter mw;
    protected boolean useClassLoadingBridge;
    protected String superClassName;
    protected String classDesc;
    protected int methodAccess;
    protected String methodName;
    protected String methodDesc;

    protected BaseClassModifier(@Nonnull ClassReader classReader) {
        super(new ClassWriter(classReader));
    }

    protected final void setUseClassLoadingBridge(@Nullable ClassLoader classLoader) {
        this.useClassLoadingBridge = ClassLoad.isClassLoaderWithNoDirectAccess(classLoader);
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        int modifiedVersion = version;
        int originalVersion = version & 0xFFFF;
        if (originalVersion < 49) {
            modifiedVersion = 49;
        }
        this.cw.visit(modifiedVersion, access, name, additionalInfo);
        this.superClassName = additionalInfo.superName;
        this.classDesc = name;
    }

    protected final void startModifiedMethodVersion(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        this.mw = this.cw.visitMethod(access & 0xFAFF, name, desc, signature, exceptions);
        this.methodAccess = access;
        this.methodName = name;
        this.methodDesc = desc;
    }

    public final boolean wasModified() {
        return this.methodName != null;
    }

    protected final void generateDirectCallToHandler(@Nonnull String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String genericSignature) {
        this.generateDirectCallToHandler(className, access, name, desc, genericSignature, ExecutionMode.Regular);
    }

    protected final void generateDirectCallToHandler(@Nonnull String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode) {
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod(access);
        this.mw.visitLdcInsn(access);
        this.mw.visitLdcInsn(className);
        this.mw.visitLdcInsn(name + desc);
        this.generateInstructionToLoadNullableString(genericSignature);
        this.mw.visitLdcInsn(executionMode.ordinal());
        JavaType[] argTypes = JavaType.getArgumentTypes(desc);
        int argCount = argTypes.length;
        if (argCount == 0) {
            this.mw.visitInsn(1);
        } else {
            this.generateCodeToCreateArrayOfObject(argCount);
            this.generateCodeToFillArrayWithParameterValues(argTypes, 0, isStatic ? 0 : 1);
        }
        this.mw.visitMethodInsn(184, "mockit/internal/expectations/RecordAndReplayExecution", "recordOrReplay", "(Ljava/lang/Object;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/Object;", false);
    }

    private void generateInstructionToLoadNullableString(@Nullable String text) {
        if (text == null) {
            this.mw.visitInsn(1);
        } else {
            this.mw.visitLdcInsn(text);
        }
    }

    protected final void generateReturnWithObjectAtTopOfTheStack(@Nonnull String mockedMethodDesc) {
        JavaType returnType = JavaType.getReturnType(mockedMethodDesc);
        TypeConversion.generateCastFromObject(this.mw, returnType);
        this.mw.visitInsn(returnType.getOpcode(172));
    }

    protected final boolean generateCodeToPassThisOrNullIfStaticMethod() {
        return this.generateCodeToPassThisOrNullIfStaticMethod(this.methodAccess);
    }

    private boolean generateCodeToPassThisOrNullIfStaticMethod(int access) {
        boolean isStatic = Modifier.isStatic(access);
        if (isStatic) {
            this.mw.visitInsn(1);
        } else {
            this.mw.visitVarInsn(25, 0);
        }
        return isStatic;
    }

    protected final void generateCodeToCreateArrayOfObject(@Nonnegative int arrayLength) {
        this.mw.visitIntInsn(17, arrayLength);
        this.mw.visitTypeInsn(189, "java/lang/Object");
    }

    protected final void generateCodeToFillArrayWithParameterValues(@Nonnull JavaType[] parameterTypes, @Nonnegative int initialArrayIndex, @Nonnegative int initialParameterIndex) {
        int i = initialArrayIndex;
        int j = initialParameterIndex;
        for (JavaType parameterType : parameterTypes) {
            this.mw.visitInsn(89);
            this.mw.visitIntInsn(17, i++);
            this.mw.visitVarInsn(parameterType.getOpcode(21), j);
            TypeConversion.generateCastToObject(this.mw, parameterType);
            this.mw.visitInsn(83);
            j += parameterType.getSize();
        }
    }

    protected final void generateCodeToObtainInstanceOfClassLoadingBridge(@Nonnull ClassLoadingBridge classLoadingBridge) {
        String hostClassName = ClassLoadingBridge.getHostClassName();
        this.mw.visitFieldInsn(178, hostClassName, classLoadingBridge.id, "Ljava/lang/reflect/InvocationHandler;");
    }

    protected final void generateCodeToFillArrayElement(@Nonnegative int arrayIndex, @Nullable Object value) {
        this.mw.visitInsn(89);
        this.mw.visitIntInsn(17, arrayIndex);
        if (value == null) {
            this.mw.visitInsn(1);
        } else if (value instanceof Integer) {
            this.mw.visitIntInsn(17, (Integer)value);
            this.mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else {
            this.mw.visitLdcInsn(value);
        }
        this.mw.visitInsn(83);
    }

    private void pushDefaultValueForType(@Nonnull JavaType type) {
        if (type instanceof ArrayType) {
            this.generateCreationOfEmptyArray((ArrayType)type);
        } else {
            int constOpcode = type.getConstOpcode();
            if (constOpcode > 0) {
                this.mw.visitInsn(constOpcode);
            }
        }
    }

    private void generateCreationOfEmptyArray(@Nonnull ArrayType arrayType) {
        int dimensions = arrayType.getDimensions();
        for (int dimension = 0; dimension < dimensions; ++dimension) {
            this.mw.visitInsn(3);
        }
        if (dimensions > 1) {
            this.mw.visitMultiANewArrayInsn(arrayType.getDescriptor(), dimensions);
            return;
        }
        JavaType elementType = arrayType.getElementType();
        if (elementType instanceof ReferenceType) {
            this.mw.visitTypeInsn(189, ((ReferenceType)elementType).getInternalName());
        } else {
            int typeCode = PrimitiveType.getArrayElementType((PrimitiveType)elementType);
            this.mw.visitIntInsn(188, typeCode);
        }
    }

    protected final void generateCallToInvocationHandler() {
        this.mw.visitMethodInsn(185, "java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true);
    }

    protected final void generateEmptyImplementation(@Nonnull String desc) {
        JavaType returnType = JavaType.getReturnType(desc);
        this.pushDefaultValueForType(returnType);
        this.mw.visitInsn(returnType.getOpcode(172));
        this.mw.visitMaxStack(1);
    }

    protected final void generateEmptyImplementation() {
        this.mw.visitInsn(177);
        this.mw.visitMaxStack(1);
    }

    @Nonnull
    protected final MethodVisitor copyOriginalImplementationWithInjectedInterceptionCode() {
        if ("<init>".equals(this.methodName)) {
            return new DynamicConstructorModifier();
        }
        this.generateInterceptionCode();
        return new DynamicModifier();
    }

    protected void generateInterceptionCode() {
    }

    private final class DynamicConstructorModifier
    extends DynamicModifier {
        private boolean pendingCallToConstructorOfSameClass;
        private boolean callToAnotherConstructorAlreadyCopied;

        private DynamicConstructorModifier() {
        }

        @Override
        public void visitTypeInsn(int opcode, @Nonnull String typeDesc) {
            this.mw.visitTypeInsn(opcode, typeDesc);
            if (opcode == 187 && !this.callToAnotherConstructorAlreadyCopied && typeDesc.equals(BaseClassModifier.this.classDesc)) {
                this.pendingCallToConstructorOfSameClass = true;
            }
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.pendingCallToConstructorOfSameClass) {
                if (opcode == 183 && "<init>".equals(name) && owner.equals(BaseClassModifier.this.classDesc)) {
                    this.pendingCallToConstructorOfSameClass = false;
                }
            } else if (opcode == 183 && !this.callToAnotherConstructorAlreadyCopied && "<init>".equals(name) && (owner.equals(BaseClassModifier.this.superClassName) || owner.equals(BaseClassModifier.this.classDesc))) {
                BaseClassModifier.this.generateInterceptionCode();
                this.callToAnotherConstructorAlreadyCopied = true;
            }
        }
    }

    private class DynamicModifier
    extends WrappingMethodVisitor {
        DynamicModifier() {
            super(BaseClassModifier.this.mw);
        }

        @Override
        public final void visitLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
            if (end.position > 0 && start.position > end.position) {
                start.position = end.position;
            }
            if (start.position > 0 && end.position > 0) {
                this.mw.visitLocalVariable(name, desc, signature, start, end, index);
            }
        }
    }
}

