/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.state.TestRun;

public final class ClassFile {
    private static final Map<String, ClassReader> CLASS_FILES = new ConcurrentHashMap<String, ClassReader>();

    private ClassFile() {
    }

    private static void verifyClassFileFound(@Nullable InputStream classFile, @Nonnull String classNameOrDesc) {
        if (classFile == null) {
            throw new NotFoundException(classNameOrDesc);
        }
    }

    @Nullable
    public static ClassReader createClassReader(@Nonnull ClassLoader cl, @Nonnull String internalClassName) {
        String classFileName = internalClassName + ".class";
        InputStream classFile = cl.getResourceAsStream(classFileName);
        if (classFile != null) {
            try {
                byte[] bytecode = ClassFile.readClass(classFile);
                return new ClassReader(bytecode);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    private static byte[] readClass(@Nonnull InputStream is) throws IOException {
        try {
            byte[] bytecode = new byte[is.available()];
            int len = 0;
            while (true) {
                int n;
                if ((n = is.read(bytecode, len, bytecode.length - len)) == -1) {
                    byte[] truncatedCopy;
                    if (len < bytecode.length) {
                        truncatedCopy = new byte[len];
                        System.arraycopy(bytecode, 0, truncatedCopy, 0, len);
                        bytecode = truncatedCopy;
                    }
                    truncatedCopy = bytecode;
                    return truncatedCopy;
                }
                if ((len += n) != bytecode.length) continue;
                int last = is.read();
                if (last < 0) {
                    byte[] byArray = bytecode;
                    return byArray;
                }
                byte[] lengthenedCopy = new byte[bytecode.length + 1000];
                System.arraycopy(bytecode, 0, lengthenedCopy, 0, len);
                lengthenedCopy[len++] = (byte)last;
                bytecode = lengthenedCopy;
            }
        }
        finally {
            is.close();
        }
    }

    @Nonnull
    public static ClassReader createReaderOrGetFromCache(@Nonnull Class<?> aClass) {
        byte[] cachedClassfile = CachedClassfiles.getClassfile(aClass);
        if (cachedClassfile != null) {
            return new ClassReader(cachedClassfile);
        }
        String classDesc = aClass.getName().replace('.', '/');
        ClassReader reader = CLASS_FILES.get(classDesc);
        if (reader == null) {
            reader = ClassFile.readFromFileSavingInCache(classDesc);
        }
        return reader;
    }

    @Nonnull
    private static ClassReader readFromFileSavingInCache(@Nonnull String classDesc) {
        byte[] classfileBytes = ClassFile.readBytesFromClassFile(classDesc);
        ClassReader cr = new ClassReader(classfileBytes);
        CLASS_FILES.put(classDesc, cr);
        return cr;
    }

    @Nonnull
    public static ClassReader createReaderFromLastRedefinitionIfAny(@Nonnull Class<?> aClass) {
        byte[] classfile = TestRun.mockFixture().getRedefinedClassfile(aClass);
        if (classfile == null) {
            classfile = CachedClassfiles.getClassfile(aClass);
        }
        if (classfile != null) {
            return new ClassReader(classfile);
        }
        String classDesc = aClass.getName().replace('.', '/');
        ClassReader reader = ClassFile.readFromFileSavingInCache(classDesc);
        return reader;
    }

    @Nonnull
    public static byte[] getClassFile(@Nonnull String internalClassName) {
        byte[] classfileBytes = CachedClassfiles.getClassfile(internalClassName);
        if (classfileBytes == null) {
            classfileBytes = ClassFile.readBytesFromClassFile(internalClassName);
        }
        return classfileBytes;
    }

    @Nonnull
    public static byte[] getClassFile(@Nullable ClassLoader loader, @Nonnull String internalClassName) {
        byte[] classfileBytes = CachedClassfiles.getClassfile(loader, internalClassName);
        if (classfileBytes == null) {
            classfileBytes = ClassFile.readBytesFromClassFile(internalClassName);
        }
        return classfileBytes;
    }

    @Nonnull
    public static byte[] getClassFile(@Nonnull Class<?> aClass) {
        byte[] classfileBytes = CachedClassfiles.getClassfile(aClass);
        if (classfileBytes == null) {
            classfileBytes = ClassFile.readBytesFromClassFile(aClass);
        }
        return classfileBytes;
    }

    @Nonnull
    public static byte[] readBytesFromClassFile(@Nonnull String classDesc) {
        byte[] classfile;
        if ((classDesc.startsWith("java/") || classDesc.startsWith("javax/")) && (classfile = CachedClassfiles.getClassfile(classDesc)) != null) {
            return classfile;
        }
        InputStream classFile = ClassFile.readClassFromClasspath(classDesc);
        try {
            byte[] bytecode = ClassFile.readClass(classFile);
            return bytecode;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + classDesc.replace('/', '.'), e);
        }
    }

    @Nonnull
    public static byte[] readBytesFromClassFile(@Nonnull Class<?> aClass) {
        String classDesc = aClass.getName().replace('.', '/');
        return ClassFile.readBytesFromClassFile(classDesc);
    }

    @Nonnull
    private static InputStream readClassFromClasspath(@Nonnull String classDesc) {
        Class<?> testClass;
        ClassLoader thisClassLoader;
        String classFileName = classDesc + ".class";
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (contextClassLoader != null) {
            inputStream = contextClassLoader.getResourceAsStream(classFileName);
        }
        if (inputStream == null && (thisClassLoader = ClassFile.class.getClassLoader()) != contextClassLoader && (inputStream = thisClassLoader.getResourceAsStream(classFileName)) == null && (testClass = TestRun.getCurrentTestClass()) != null) {
            inputStream = testClass.getClassLoader().getResourceAsStream(classFileName);
        }
        ClassFile.verifyClassFileFound(inputStream, classDesc);
        return inputStream;
    }

    public static final class NotFoundException
    extends RuntimeException {
        private NotFoundException(@Nonnull String classNameOrDesc) {
            super("Unable to find class file for " + classNameOrDesc.replace('/', '.'));
        }
    }
}

