/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.security.ProtectionDomain;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.Expectations;
import mockit.MockUp;
import mockit.Verifications;
import mockit.internal.util.GeneratedClasses;

final class CapturedType {
    private static final ProtectionDomain JMOCKIT_DOMAIN = CapturedType.class.getProtectionDomain();
    @Nonnull
    final Class<?> baseType;

    CapturedType(@Nonnull Class<?> baseType) {
        this.baseType = baseType;
    }

    boolean isToBeCaptured(@Nonnull Class<?> aClass) {
        if (aClass == this.baseType || aClass.isArray() || !this.baseType.isAssignableFrom(aClass) || CapturedType.extendsJMockitBaseType(aClass)) {
            return false;
        }
        return !aClass.isInterface() && !CapturedType.isNotToBeCaptured(aClass.getProtectionDomain(), aClass.getName());
    }

    private static boolean extendsJMockitBaseType(@Nonnull Class<?> aClass) {
        return MockUp.class.isAssignableFrom(aClass) || Expectations.class.isAssignableFrom(aClass) || Verifications.class.isAssignableFrom(aClass) || Delegate.class.isAssignableFrom(aClass);
    }

    static boolean isNotToBeCaptured(@Nullable ProtectionDomain pd, @Nonnull String classNameOrDesc) {
        return pd == JMOCKIT_DOMAIN || classNameOrDesc.endsWith("Test") || CapturedType.isNonEligibleInternalJDKClass(classNameOrDesc) || CapturedType.isNonEligibleStandardJavaClass(classNameOrDesc) || CapturedType.isNonEligibleClassFromIDERuntime(classNameOrDesc) || CapturedType.isNonEligibleClassFromThirdPartyLibrary(classNameOrDesc) || GeneratedClasses.isGeneratedClass(classNameOrDesc) || GeneratedClasses.isExternallyGeneratedSubclass(classNameOrDesc);
    }

    private static boolean isNonEligibleInternalJDKClass(@Nonnull String classNameOrDesc) {
        return classNameOrDesc.startsWith("jdk/") || classNameOrDesc.startsWith("sun") && !CapturedType.hasSubPackage(classNameOrDesc, 4, "management") || classNameOrDesc.startsWith("com") && CapturedType.hasSubPackage(classNameOrDesc, 4, "sun") && !CapturedType.hasSubPackages(classNameOrDesc, 8, "proxy org");
    }

    private static boolean isNonEligibleStandardJavaClass(@Nonnull String classNameOrDesc) {
        return classNameOrDesc.startsWith("java") && !CapturedType.hasSubPackage(classNameOrDesc, 10, "concurrent");
    }

    private static boolean isNonEligibleClassFromIDERuntime(@Nonnull String classNameOrDesc) {
        return classNameOrDesc.startsWith("com") && CapturedType.hasSubPackage(classNameOrDesc, 4, "intellij");
    }

    private static boolean isNonEligibleClassFromThirdPartyLibrary(@Nonnull String classNameOrDesc) {
        return classNameOrDesc.startsWith("junit") || classNameOrDesc.startsWith("org") && CapturedType.hasSubPackages(classNameOrDesc, 4, "junit testng hamcrest gradle");
    }

    private static boolean hasSubPackage(@Nonnull String nameOrDesc, @Nonnegative int offset, @Nonnull String subPackage) {
        return nameOrDesc.regionMatches(offset, subPackage, 0, subPackage.length());
    }

    private static boolean hasSubPackages(@Nonnull String nameOrDesc, @Nonnegative int offset, @Nonnull String subPackages) {
        int subPackageEnd;
        int subPackageStart = 0;
        do {
            int subPackageLength;
            if (nameOrDesc.regionMatches(offset, subPackages, subPackageStart, subPackageLength = ((subPackageEnd = subPackages.indexOf(32, subPackageStart)) > 0 ? subPackageEnd : subPackages.length()) - subPackageStart)) {
                return true;
            }
            subPackageStart = subPackageEnd + 1;
        } while (subPackageEnd > 0);
        return false;
    }
}

