/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;

public final class NumericEqualityMatcher
implements ArgumentMatcher<NumericEqualityMatcher> {
    private final double value;
    private final double delta;

    public NumericEqualityMatcher(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    @Override
    public boolean same(@Nonnull NumericEqualityMatcher other) {
        return this.value == other.value && this.delta == other.delta;
    }

    @Override
    public boolean matches(@Nullable Object decimalValue) {
        return decimalValue instanceof Number && this.actualDelta((Number)decimalValue) <= this.delta;
    }

    private double actualDelta(@Nonnull Number decimalValue) {
        return Math.abs(decimalValue.doubleValue() - this.value);
    }

    @Override
    public void writeMismatchPhrase(@Nonnull ArgumentMismatch argumentMismatch) {
        argumentMismatch.append("a numeric value within ").append(this.delta).append(" of ").append(this.value);
    }
}

