/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.methods.MethodWriter;
import mockit.asm.types.ArrayType;
import mockit.asm.types.JavaType;
import mockit.asm.types.ObjectType;
import mockit.asm.types.ReferenceType;
import mockit.internal.expectations.transformation.InvocationBlockModifier;
import mockit.internal.util.TypeConversion;

final class Capture {
    @Nonnull
    private final InvocationBlockModifier invocationBlockModifier;
    @Nonnull
    private final MethodWriter mw;
    @Nonnegative
    private final int opcode;
    @Nonnegative
    private final int varIndex;
    @Nullable
    private String typeToCapture;
    @Nonnegative
    private int parameterIndex;
    @Nonnegative
    private boolean parameterIndexFixed;

    Capture(@Nonnull InvocationBlockModifier invocationBlockModifier, @Nonnegative int opcode, @Nonnegative int varIndex, @Nullable String typeToCapture, @Nonnegative int parameterIndex) {
        this.invocationBlockModifier = invocationBlockModifier;
        this.mw = invocationBlockModifier.getMethodWriter();
        this.opcode = opcode;
        this.varIndex = varIndex;
        this.typeToCapture = typeToCapture;
        this.parameterIndex = parameterIndex;
    }

    Capture(@Nonnull InvocationBlockModifier invocationBlockModifier, @Nonnegative int varIndex, @Nonnegative int parameterIndex) {
        this.invocationBlockModifier = invocationBlockModifier;
        this.mw = invocationBlockModifier.getMethodWriter();
        this.opcode = 25;
        this.varIndex = varIndex;
        this.parameterIndex = parameterIndex;
    }

    void generateCodeToStoreCapturedValue() {
        if (this.opcode != 25) {
            this.mw.visitIntInsn(17, this.parameterIndex);
            if (this.typeToCapture == null) {
                this.mw.visitInsn(1);
            } else {
                this.mw.visitLdcInsn(this.typeToCapture);
            }
            this.invocationBlockModifier.generateCallToActiveInvocationsMethod("matchedArgument", "(ILjava/lang/String;)Ljava/lang/Object;");
            JavaType argType = this.getArgumentType();
            TypeConversion.generateCastOrUnboxing(this.mw, argType, this.opcode);
            this.mw.visitVarInsn(this.opcode, this.varIndex);
        }
    }

    @Nonnull
    private JavaType getArgumentType() {
        if (this.typeToCapture == null) {
            return this.invocationBlockModifier.argumentMatching.getParameterType(this.parameterIndex);
        }
        if (this.typeToCapture.charAt(0) == '[') {
            return ArrayType.create(this.typeToCapture);
        }
        return ObjectType.create(this.typeToCapture);
    }

    boolean fixParameterIndex(@Nonnegative int originalIndex, @Nonnegative int newIndex) {
        if (!this.parameterIndexFixed && this.parameterIndex == originalIndex) {
            this.parameterIndex = newIndex;
            this.parameterIndexFixed = true;
            return true;
        }
        return false;
    }

    void generateCallToSetArgumentTypeIfNeeded() {
        if (this.opcode == 25) {
            this.mw.visitIntInsn(17, this.parameterIndex);
            this.mw.visitLdcInsn(this.varIndex);
            this.invocationBlockModifier.generateCallToActiveInvocationsMethod("setExpectedArgumentType", "(II)V");
        } else if (this.typeToCapture != null && !this.isTypeToCaptureSameAsParameterType(this.typeToCapture)) {
            this.mw.visitIntInsn(17, this.parameterIndex);
            this.mw.visitLdcInsn(this.typeToCapture);
            this.invocationBlockModifier.generateCallToActiveInvocationsMethod("setExpectedArgumentType", "(ILjava/lang/String;)V");
        }
    }

    private boolean isTypeToCaptureSameAsParameterType(@Nonnull String typeDesc) {
        JavaType parameterType = this.invocationBlockModifier.argumentMatching.getParameterType(this.parameterIndex);
        if (parameterType instanceof ReferenceType) {
            String parameterTypeDesc = ((ReferenceType)parameterType).getInternalName();
            return typeDesc.equals(parameterTypeDesc);
        }
        return TypeConversion.isPrimitiveWrapper(typeDesc);
    }
}

