/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.util.Utilities;

final class MultiValuedProvider
extends InjectionProvider {
    @Nonnull
    private final List<InjectionProvider> individualProviders = new ArrayList<InjectionProvider>();

    MultiValuedProvider(@Nonnull Type elementType) {
        super(elementType, "");
    }

    void addInjectable(@Nonnull InjectionProvider provider) {
        this.individualProviders.add(provider);
    }

    @Override
    @Nonnull
    public Class<?> getClassOfDeclaredType() {
        return Utilities.getClassType(this.declaredType);
    }

    @Override
    @Nonnull
    public Object getValue(@Nullable Object owner) {
        ArrayList<Object> values = new ArrayList<Object>(this.individualProviders.size());
        for (InjectionProvider provider : this.individualProviders) {
            Object value = provider.getValue(owner);
            values.add(value);
        }
        return values;
    }
}

