/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.injection.field.FieldInjection;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.DefaultValues;

abstract class TestedObject {
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    final Tested metadata;
    @Nonnull
    private final String testedName;
    @Nullable
    private final FullInjection fullInjection;
    @Nonnull
    private final TestedClass testedClass;
    @Nullable
    private final TestedObjectCreation testedObjectCreation;
    @Nullable
    private List<Field> targetFields;
    boolean createAutomatically;

    @Nullable
    static Tested getTestedAnnotationIfPresent(@Nonnull Annotation annotation) {
        if (annotation instanceof Tested) {
            return (Tested)annotation;
        }
        return annotation.annotationType().getAnnotation(Tested.class);
    }

    TestedObject(@Nonnull InjectionState injectionState, @Nonnull Tested metadata, @Nonnull Class<?> testClass, @Nonnull String testedName, @Nonnull Type testedType, @Nonnull Class<?> testedClass) {
        this.injectionState = injectionState;
        this.metadata = metadata;
        this.testedName = testedName;
        FullInjection fullInjection = this.fullInjection = metadata.fullyInitialized() ? new FullInjection(injectionState, testedClass, testedName) : null;
        if (testedClass.isInterface() || testedClass.isEnum() || testedClass.isPrimitive() || testedClass.isArray()) {
            this.testedObjectCreation = null;
            this.testedClass = new TestedClass(testedType, testedClass);
        } else {
            this.testedObjectCreation = new TestedObjectCreation(injectionState, this.fullInjection, testedType, testedClass);
            this.testedClass = this.testedObjectCreation.testedClass;
            injectionState.lifecycleMethods.findLifecycleMethods(testedClass);
        }
        this.testedClass.testClass = testClass;
    }

    boolean isAvailableDuringSetup() {
        return this.metadata.availableDuringSetup();
    }

    void instantiateWithInjectableValues(@Nonnull Object testClassInstance) {
        if (this.alreadyInstantiated(testClassInstance)) {
            return;
        }
        Object testedObject = this.getExistingTestedInstanceIfApplicable(testClassInstance);
        Class<?> testedObjectClass = this.testedClass.targetClass;
        InjectionPoint injectionPoint = new InjectionPoint(this.testedClass.declaredType, this.testedName);
        if (TestedObject.isNonInstantiableType(testedObjectClass, testedObject)) {
            this.reusePreviouslyCreatedInstance(testClassInstance, injectionPoint);
            return;
        }
        if (testedObject == null && this.createAutomatically) {
            if (this.reusePreviouslyCreatedInstance(testClassInstance, injectionPoint)) {
                return;
            }
            testedObject = this.createAndRegisterNewObject(testClassInstance, injectionPoint);
        } else if (testedObject != null) {
            this.registerTestedObject(injectionPoint, testedObject);
            testedObjectClass = testedObject.getClass();
        }
        if (testedObject != null && testedObjectClass.getClassLoader() != null) {
            this.performFieldInjection(testedObjectClass, testedObject);
            if (this.createAutomatically) {
                this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(testedObjectClass, testedObject);
            }
        }
    }

    boolean alreadyInstantiated(@Nonnull Object testClassInstance) {
        return false;
    }

    @Nullable
    abstract Object getExistingTestedInstanceIfApplicable(@Nonnull Object var1);

    static boolean isNonInstantiableType(@Nonnull Class<?> targetClass, @Nullable Object currentValue) {
        return targetClass.isPrimitive() && DefaultValues.defaultValueForPrimitiveType(targetClass).equals(currentValue) || currentValue == null && (targetClass.isArray() || targetClass.isEnum() || targetClass.isAnnotation() || AutoBoxing.isWrapperOfPrimitiveType(targetClass));
    }

    private boolean reusePreviouslyCreatedInstance(@Nonnull Object testClassInstance, @Nonnull InjectionPoint injectionPoint) {
        Object previousInstance = this.injectionState.getTestedInstance(injectionPoint, this.metadata.global());
        if (previousInstance != null) {
            this.setInstance(testClassInstance, previousInstance);
            return true;
        }
        return false;
    }

    abstract void setInstance(@Nonnull Object var1, @Nullable Object var2);

    @Nullable
    private Object createAndRegisterNewObject(@Nonnull Object testClassInstance, @Nonnull InjectionPoint injectionPoint) {
        Object testedInstance = null;
        if (this.testedObjectCreation != null && (testedInstance = this.testedObjectCreation.create(false)) != null) {
            this.setInstance(testClassInstance, testedInstance);
            this.registerTestedObject(injectionPoint, testedInstance);
        }
        return testedInstance;
    }

    private void registerTestedObject(@Nonnull InjectionPoint injectionPoint, @Nonnull Object testedObject) {
        this.injectionState.saveTestedObject(injectionPoint, testedObject, this.metadata.global());
    }

    private void performFieldInjection(@Nonnull Class<?> targetClass, @Nonnull Object testedObject) {
        FieldInjection fieldInjection = new FieldInjection(this.injectionState, this.fullInjection);
        if (this.targetFields == null) {
            this.targetFields = Injector.findAllTargetInstanceFieldsInTestedClassHierarchy(targetClass, this.testedClass);
        }
        fieldInjection.injectIntoEligibleFields(this.targetFields, testedObject, this.testedClass);
    }

    void clearIfAutomaticCreation(@Nonnull Object testClassInstance, boolean duringTearDown) {
        if (this.createAutomatically && (duringTearDown || !this.isAvailableDuringSetup())) {
            this.setInstance(testClassInstance, null);
            if (this.fullInjection != null) {
                this.fullInjection.clear();
            }
        }
    }
}

