/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.constructor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.util.Utilities;

final class ConstructorParameter
extends InjectionProvider {
    @Nonnull
    private final Class<?> classOfDeclaredType;
    @Nonnull
    private final Annotation[] annotations;
    @Nullable
    private final Object value;

    ConstructorParameter(@Nonnull Type declaredType, @Nonnull Annotation[] annotations, @Nonnull String name, @Nullable Object value) {
        super(declaredType, name);
        this.classOfDeclaredType = Utilities.getClassType(declaredType);
        this.annotations = annotations;
        this.value = value;
    }

    @Override
    @Nonnull
    public Class<?> getClassOfDeclaredType() {
        return this.classOfDeclaredType;
    }

    @Override
    @Nonnull
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Object owner) {
        return this.value;
    }

    @Override
    public String toString() {
        return "parameter " + super.toString();
    }
}

