/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.startup.Startup;

public final class CachedClassfiles
implements ClassFileTransformer {
    @Nonnull
    public static final CachedClassfiles INSTANCE = new CachedClassfiles();
    @Nonnull
    private final Map<ClassLoader, Map<String, byte[]>> classLoadersAndClassfiles = new WeakHashMap<ClassLoader, Map<String, byte[]>>(2);
    @Nullable
    private Class<?> classBeingCached;

    private CachedClassfiles() {
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, String classDesc, @Nullable Class<?> classBeingRedefinedOrRetransformed, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        if (classDesc != null && classBeingRedefinedOrRetransformed != null && classBeingRedefinedOrRetransformed == this.classBeingCached) {
            this.addClassfile(loader, classDesc, classfileBuffer);
            this.classBeingCached = null;
        }
        return null;
    }

    private void addClassfile(@Nullable ClassLoader loader, @Nonnull String classDesc, @Nonnull byte[] classfile) {
        Map<String, byte[]> classfiles = this.getClassfiles(loader);
        classfiles.put(classDesc, classfile);
    }

    @Nonnull
    private Map<String, byte[]> getClassfiles(@Nullable ClassLoader loader) {
        Map<String, byte[]> classfiles = this.classLoadersAndClassfiles.get(loader);
        if (classfiles == null) {
            classfiles = new HashMap<String, byte[]>(100);
            this.classLoadersAndClassfiles.put(loader, classfiles);
        }
        return classfiles;
    }

    @Nullable
    private byte[] findClassfile(@Nonnull Class<?> aClass) {
        String className = aClass.getName();
        int p = className.indexOf(47);
        if (p > 0) {
            className = className.substring(0, p);
        }
        Map<String, byte[]> classfiles = this.getClassfiles(aClass.getClassLoader());
        return classfiles.get(className.replace('.', '/'));
    }

    @Nullable
    public static synchronized byte[] getClassfile(@Nonnull String classDesc) {
        return INSTANCE.findClassfile(classDesc);
    }

    @Nullable
    private byte[] findClassfile(@Nonnull String classDesc) {
        byte[] classfile = null;
        for (Map<String, byte[]> classfiles : this.classLoadersAndClassfiles.values()) {
            classfile = classfiles.get(classDesc);
            if (classfile == null) continue;
            return classfile;
        }
        Class<?> desiredClass = Startup.getClassIfLoaded(classDesc);
        if (desiredClass != null) {
            this.classBeingCached = desiredClass;
            Startup.retransformClass(desiredClass);
            ClassLoader classLoader = desiredClass.getClassLoader();
            classfile = INSTANCE.findClassfile(classLoader, classDesc);
        }
        return classfile;
    }

    @Nullable
    private synchronized byte[] findClassfile(@Nullable ClassLoader loader, @Nonnull String classDesc) {
        Map<String, byte[]> classfiles = this.getClassfiles(loader);
        return classfiles.get(classDesc);
    }

    @Nullable
    public static synchronized byte[] getClassfile(@Nonnull Class<?> aClass) {
        byte[] cached = INSTANCE.findClassfile(aClass);
        if (cached != null) {
            return cached;
        }
        CachedClassfiles.INSTANCE.classBeingCached = aClass;
        Startup.retransformClass(aClass);
        return INSTANCE.findClassfile(aClass);
    }

    @Nullable
    public static byte[] getClassfile(@Nullable ClassLoader loader, @Nonnull String internalClassName) {
        return INSTANCE.findClassfile(loader, internalClassName);
    }

    public static void addClassfile(@Nonnull Class<?> aClass, @Nonnull byte[] classfile) {
        INSTANCE.addClassfile(aClass.getClassLoader(), aClass.getName().replace('.', '/'), classfile);
    }
}

