/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.ContextTestSuite;
import javolution.JavolutionError;
import javolution.UtilTestSuite;
import javolution.context.LogContext;
import javolution.lang.Configurable;
import javolution.testing.TestContext;
import javolution.testing.TimeContext;

public class Javolution {
    public static final String VERSION = "5.2.3 (J2SE 1.5+) September 6 2007";

    protected Javolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        LogContext.enter(LogContext.SYSTEM_OUT);
        try {
            LogContext.info("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
            LogContext.info("Version 5.2.3 (J2SE 1.5+) September 6 2007 (http://javolution.org)");
            LogContext.info("");
            if (stringArray.length > 0) {
                if (stringArray[0].equals("version")) {
                    return;
                }
                if (stringArray[0].equals("test")) {
                    Javolution.builtInTests();
                    return;
                }
                if (stringArray[0].equals("perf")) {
                    TimeContext.enter();
                    try {
                        Javolution.builtInTests();
                    }
                    finally {
                        TimeContext.exit();
                    }
                    return;
                }
            }
            LogContext.info("Usage: java -jar javolution.jar [arg]");
            LogContext.info("where arg is one of:");
            LogContext.info("    version (to show version information only)");
            LogContext.info("    test    (to perform self-tests)");
            LogContext.info("    perf    (to run benchmark)");
        }
        finally {
            LogContext.exit();
        }
    }

    private static void builtInTests() {
        LogContext.info("Load Configurable Parameters from System.getProperties()...");
        Configurable.read(System.getProperties());
        LogContext.info("");
        Thread.currentThread().setPriority(10);
        new ContextTestSuite().run();
        new UtilTestSuite().run();
        TestContext.info("More tests coming soon...");
    }

    public static Class j2meGetClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            throw new JavolutionError("Class " + string + " not found");
        }
        return clazz;
    }

    public static CharSequence j2meToCharSeq(Object object) {
        return (CharSequence)object;
    }
}

