/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.ObjectFactory;
import org.jscience.mathematics.number.LargeInteger;

final class Calculus {
    static final long MASK_63 = Long.MAX_VALUE;
    static final long MASK_32 = 0xFFFFFFFFL;
    static final long MASK_31 = Integer.MAX_VALUE;
    static final long MASK_8 = 255L;

    private Calculus() {
    }

    static int add(long[] x, int xSize, long y) {
        long sum = x[0] + y;
        x[0] = sum & Long.MAX_VALUE;
        int i = 1;
        sum >>>= 63;
        while (sum != 0L) {
            if (i == xSize) {
                x[xSize] = sum;
                return xSize + 1;
            }
            x[i++] = (sum += x[i]) & Long.MAX_VALUE;
            sum >>>= 63;
        }
        return xSize;
    }

    static int add(long[] x, int xSize, long[] y, int ySize, long[] z) {
        long sum = 0L;
        int i = 0;
        while (i < ySize) {
            z[i++] = (sum += x[i] + y[i]) & Long.MAX_VALUE;
            sum >>>= 63;
        }
        while (true) {
            if (sum == 0L) {
                while (i < xSize) {
                    z[i] = x[i++];
                }
                return xSize;
            }
            if (i == xSize) {
                z[xSize] = sum;
                return xSize + 1;
            }
            z[i++] = (sum += x[i]) & Long.MAX_VALUE;
            sum >>>= 63;
        }
    }

    static int subtract(long[] x, int xSize, long[] y, int ySize, long[] z) {
        long diff = 0L;
        int i = 0;
        while (i < ySize) {
            z[i++] = (diff += x[i] - y[i]) & Long.MAX_VALUE;
            diff >>= 63;
        }
        while (diff != 0L) {
            z[i++] = (diff += x[i]) & Long.MAX_VALUE;
            diff >>= 63;
        }
        while (i < xSize) {
            z[i] = x[i++];
        }
        int j = xSize;
        while (j > 0) {
            if (z[--j] == 0L) continue;
            return j + 1;
        }
        return 0;
    }

    static int compare(long[] x, long[] y, int size) {
        int i = size;
        while (--i >= 0) {
            if (x[i] > y[i]) {
                return 1;
            }
            if (x[i] >= y[i]) continue;
            return -1;
        }
        return 0;
    }

    static int shiftLeft(int wordShift, int bitShift, long[] x, int xSize, long[] z) {
        long tmp;
        long high;
        int shiftRight = 63 - bitShift;
        int i = xSize;
        int j = xSize + wordShift;
        if ((high = (tmp = x[--i]) >>> shiftRight) != 0L) {
            z[j] = high;
        }
        while (i > 0) {
            long l = tmp << bitShift & Long.MAX_VALUE;
            tmp = x[--i];
            z[--j] = l | tmp >>> shiftRight;
        }
        z[--j] = tmp << bitShift & Long.MAX_VALUE;
        while (j > 0) {
            z[--j] = 0L;
        }
        return high != 0L ? xSize + wordShift + 1 : xSize + wordShift;
    }

    static int shiftRight(int wordShift, int bitShift, long[] x, int xSize, long[] z) {
        int shiftLeft = 63 - bitShift;
        int i = wordShift;
        int j = 0;
        long tmp = x[i];
        while (i < xSize - 1) {
            int n = j++;
            long l = tmp >>> bitShift;
            tmp = x[++i];
            z[n] = l | tmp << shiftLeft & Long.MAX_VALUE;
        }
        z[j] = tmp >>>= bitShift;
        return tmp != 0L ? j + 1 : j;
    }

    static int multiply(long[] x, int xSize, long y, long[] z) {
        return Calculus.multiply(x, xSize, y, z, 0);
    }

    static int multiply(long[] x, int xSize, long[] y, int ySize, long[] z) {
        int zSize = 0;
        int i = 0;
        while (i < ySize) {
            zSize = Calculus.multiply(x, xSize, y[i], z, i++);
        }
        return zSize;
    }

    private static int multiply(long[] x, int xSize, long k, long[] z, int shift) {
        long kl = k & 0xFFFFFFFFL;
        long kh = k >> 32;
        long carry = 0L;
        int i = 0;
        int j = shift;
        while (i < xSize) {
            long zz = shift == 0 ? carry : z[j] + carry;
            carry = zz >>> 63;
            zz &= Long.MAX_VALUE;
            long w = x[i++];
            long wl = w & 0xFFFFFFFFL;
            long wh = w >> 32;
            long tmp = wl * kl;
            carry += tmp >>> 63;
            carry += (zz += tmp & Long.MAX_VALUE) >>> 63;
            zz &= Long.MAX_VALUE;
            tmp = wl * kh + wh * kl;
            carry += tmp >>> 31;
            carry += (zz += tmp << 32 & Long.MAX_VALUE) >>> 63;
            z[j++] = zz & Long.MAX_VALUE;
            carry += wh * kh << 1;
        }
        int size = shift + xSize;
        z[size] = carry;
        if (carry == 0L) {
            return size;
        }
        return ++size;
    }

    static long divide(long[] x, int xSize, int y, long[] z) {
        long r = 0L;
        int i = xSize;
        while (i > 0) {
            long w = x[--i];
            long wh = r << 31 | w >>> 32;
            long qh = wh / (long)y;
            r = wh - qh * (long)y;
            long wl = r << 32 | w & 0xFFFFFFFFL;
            long ql = wl / (long)y;
            r = wl - ql * (long)y;
            z[i] = qh << 32 | ql;
        }
        return r;
    }

    static final class MultiplyLogic
    implements Runnable {
        private static final ObjectFactory<MultiplyLogic> FACTORY = new ObjectFactory<MultiplyLogic>(){

            @Override
            protected MultiplyLogic create() {
                return new MultiplyLogic();
            }
        };
        private LargeInteger _left;
        private LargeInteger _right;
        private LargeInteger _value;

        MultiplyLogic() {
        }

        public static MultiplyLogic newInstance(LargeInteger left, LargeInteger right) {
            MultiplyLogic logic = FACTORY.object();
            logic._left = left;
            logic._right = right;
            return logic;
        }

        @Override
        public void run() {
            this._value = this._left.times(this._right);
        }

        public LargeInteger value() {
            return this._value;
        }
    }
}

