/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Comparator;
import javolution.context.StackContext;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.structure.Ring;
import org.jscience.mathematics.structure.VectorSpace;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Vector;

public abstract class Matrix<F extends Field<F>>
implements VectorSpace<Matrix<F>, F>,
Ring<Matrix<F>>,
ValueType,
Realtime {
    protected static final XMLFormat<Matrix> XML = new XMLFormat<Matrix>(Matrix.class){

        @Override
        public void read(XMLFormat.InputElement xml, Matrix M) throws XMLStreamException {
        }

        @Override
        public void write(Matrix M, XMLFormat.OutputElement xml) throws XMLStreamException {
            int m = M.getNumberOfRows();
            int n = M.getNumberOfColumns();
            xml.setAttribute("rows", m);
            xml.setAttribute("columns", n);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    xml.add(M.get(i, j));
                }
            }
        }
    };

    protected Matrix() {
    }

    public abstract int getNumberOfRows();

    public abstract int getNumberOfColumns();

    public abstract F get(int var1, int var2);

    public abstract Vector<F> getRow(int var1);

    public abstract Vector<F> getColumn(int var1);

    public abstract Vector<F> getDiagonal();

    @Override
    public abstract Matrix<F> opposite();

    @Override
    public abstract Matrix<F> plus(Matrix<F> var1);

    public Matrix<F> minus(Matrix<F> that) {
        return this.plus((Matrix<F>)that.opposite());
    }

    @Override
    public abstract Matrix<F> times(F var1);

    @Override
    public abstract Vector<F> times(Vector<F> var1);

    @Override
    public abstract Matrix<F> times(Matrix<F> var1);

    public abstract Matrix<F> inverse();

    public Matrix<F> divide(Matrix<F> that) {
        return this.times(that.inverse());
    }

    public Matrix<F> pseudoInverse() {
        if (this.isSquare()) {
            return this.inverse();
        }
        Matrix<F> thisTranspose = this.transpose();
        return thisTranspose.times(this).inverse().times(thisTranspose);
    }

    public abstract F determinant();

    public abstract Matrix<F> transpose();

    public abstract F cofactor(int var1, int var2);

    public abstract Matrix<F> adjoint();

    public boolean isSquare() {
        return this.getNumberOfRows() == this.getNumberOfColumns();
    }

    public Vector<F> solve(Vector<F> y) {
        DenseMatrix M = DenseMatrix.newInstance(y.getDimension(), true);
        M._rows.add(DenseVector.valueOf(y));
        return this.solve(M).getColumn(0);
    }

    public Matrix<F> solve(Matrix<F> y) {
        return LUDecomposition.valueOf(this).solve(y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix<F> pow(int exp) {
        if (exp > 0) {
            StackContext.enter();
            try {
                Matrix<F> pow2 = this;
                Matrix<F> result = null;
                while (exp >= 1) {
                    if ((exp & 1) == 1) {
                        result = result == null ? pow2 : result.times(pow2);
                    }
                    pow2 = pow2.times(pow2);
                    exp >>>= 1;
                }
                Matrix matrix = StackContext.outerCopy(result);
                return matrix;
            }
            finally {
                StackContext.exit();
            }
        }
        if (exp == 0) {
            return this.times(this.inverse());
        }
        return this.pow(-exp).inverse();
    }

    public F trace() {
        Object sum = this.get(0, 0);
        int i = MathLib.min(this.getNumberOfColumns(), this.getNumberOfRows());
        while (--i > 0) {
            sum = (Field)sum.plus(this.get(i, i));
        }
        return sum;
    }

    public abstract Matrix<F> tensor(Matrix<F> var1);

    public abstract Vector<F> vectorization();

    @Override
    public Text toText() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        TextBuilder tmp = TextBuilder.newInstance();
        tmp.append('{');
        for (int i = 0; i < m; ++i) {
            tmp.append('{');
            for (int j = 0; j < n; ++j) {
                tmp.append(this.get(i, j));
                if (j == n - 1) continue;
                tmp.append(", ");
            }
            tmp.append("}");
            if (i == m - 1) continue;
            tmp.append(",\n");
        }
        tmp.append("}");
        Text txt = tmp.toText();
        TextBuilder.recycle(tmp);
        return txt;
    }

    public final String toString() {
        return this.toText().toString();
    }

    public boolean equals(Matrix<F> that, Comparator<F> cmp) {
        if (this == that) {
            return true;
        }
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        if (that.getNumberOfRows() != m || that.getNumberOfColumns() != n) {
            return false;
        }
        int i = m;
        while (--i >= 0) {
            int j = n;
            while (--j >= 0) {
                if (cmp.compare(this.get(i, j), that.get(i, j)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Matrix)) {
            return false;
        }
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        Matrix M = (Matrix)that;
        if (M.getNumberOfRows() != m || M.getNumberOfColumns() != n) {
            return false;
        }
        int i = m;
        while (--i >= 0) {
            int j = n;
            while (--j >= 0) {
                if (this.get(i, j).equals(M.get(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int code = 0;
        int i = m;
        while (--i >= 0) {
            int j = n;
            while (--j >= 0) {
                code += this.get(i, j).hashCode();
            }
        }
        return code;
    }

    @Override
    public abstract Matrix<F> copy();
}

