/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Map;
import javolution.context.ObjectFactory;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.Index;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class SparseVector<F extends Field<F>>
extends Vector<F> {
    protected static final XMLFormat<SparseVector> XML = new XMLFormat<SparseVector>(SparseVector.class){

        @Override
        public SparseVector newInstance(Class<SparseVector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (SparseVector)FACTORY.object();
        }

        @Override
        public void read(XMLFormat.InputElement xml, SparseVector V) throws XMLStreamException {
            V._dimension = xml.getAttribute("dimension", 0);
            V._zero = (Field)xml.get("Zero");
            V._elements.putAll(xml.get("Elements", FastMap.class));
        }

        @Override
        public void write(SparseVector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("dimension", V._dimension);
            xml.add(V._zero, "Zero");
            xml.add(V._elements, "Elements", FastMap.class);
        }
    };
    int _dimension;
    F _zero;
    final FastMap<Index, F> _elements = new FastMap();
    private static final ObjectFactory<SparseVector> FACTORY = new ObjectFactory<SparseVector>(){

        @Override
        protected SparseVector create() {
            return new SparseVector();
        }

        @Override
        protected void cleanup(SparseVector vector) {
            vector._elements.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> SparseVector<F> valueOf(int dimension, F zero, int i, F element) {
        SparseVector<F> V = SparseVector.newInstance(dimension, zero);
        V._elements.put(Index.valueOf(i), element);
        return V;
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(int dimension, F zero, Map<Index, F> elements) {
        SparseVector<F> V = SparseVector.newInstance(dimension, zero);
        V._elements.putAll(elements);
        return V;
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(Vector<F> that, F zero) {
        return SparseVector.valueOf(that, zero, FastComparator.DEFAULT);
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(Vector<F> that, F zero, FastComparator<? super F> comparator) {
        if (that instanceof SparseVector) {
            return SparseVector.valueOf((SparseVector)that, zero, comparator);
        }
        int n = that.getDimension();
        SparseVector<F> V = SparseVector.newInstance(n, zero);
        for (int i = 0; i < n; ++i) {
            F element = that.get(i);
            if (comparator.areEqual(zero, element)) continue;
            V._elements.put(Index.valueOf(i), element);
        }
        return V;
    }

    private static <F extends Field<F>> SparseVector<F> valueOf(SparseVector<F> that, F zero, FastComparator<? super F> comparator) {
        SparseVector<F> V = SparseVector.newInstance(that._dimension, zero);
        FastCollection.Record e = that._elements.head();
        FastMap.Entry<Index, F> n = that._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != n) {
            if (comparator.areEqual(((FastMap.Entry)e).getValue(), zero)) continue;
            V._elements.put((Index)((FastMap.Entry)e).getKey(), (F)((FastMap.Entry)e).getValue());
        }
        return V;
    }

    public F getZero() {
        return this._zero;
    }

    @Override
    public int getDimension() {
        return this._dimension;
    }

    @Override
    public F get(int i) {
        if (i < 0 || i >= this._dimension) {
            throw new IndexOutOfBoundsException();
        }
        Field element = (Field)this._elements.get(Index.valueOf(i));
        return (F)(element == null ? this._zero : element);
    }

    @Override
    public SparseVector<F> opposite() {
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        FastCollection.Record e = this._elements.head();
        FastMap.Entry<Index, F> n = this._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != n) {
            V._elements.put((Index)((FastMap.Entry)e).getKey(), (F)((Field)((FastMap.Entry)e).getValue()).opposite());
        }
        return V;
    }

    @Override
    public SparseVector<F> plus(Vector<F> that) {
        if (that instanceof SparseVector) {
            return this.plus((SparseVector)that);
        }
        return this.plus(SparseVector.valueOf(that, this._zero, FastComparator.DEFAULT));
    }

    @Override
    private SparseVector<F> plus(SparseVector<F> that) {
        if (this._dimension != that._dimension) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        V._elements.putAll(this._elements);
        FastCollection.Record e = that._elements.head();
        FastMap.Entry<Index, F> n = that._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != n) {
            Index index = (Index)((FastMap.Entry)e).getKey();
            FastMap.Entry<Index, F> entry = V._elements.getEntry(index);
            if (entry == null) {
                V._elements.put(index, ((FastMap.Entry)e).getValue());
                continue;
            }
            entry.setValue(((Field)entry.getValue()).plus(((FastMap.Entry)e).getValue()));
        }
        return V;
    }

    @Override
    public SparseVector<F> times(F k) {
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        FastCollection.Record e = this._elements.head();
        FastMap.Entry<Index, F> n = this._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != n) {
            V._elements.put((Index)((FastMap.Entry)e).getKey(), ((Field)((FastMap.Entry)e).getValue()).times(k));
        }
        return V;
    }

    @Override
    public F times(Vector<F> that) {
        if (that.getDimension() != this._dimension) {
            throw new DimensionException();
        }
        Field sum = null;
        FastCollection.Record e = this._elements.head();
        FastMap.Entry<Index, F> n = this._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != n) {
            Field f = (Field)((Field)((FastMap.Entry)e).getValue()).times(that.get(((Index)((FastMap.Entry)e).getKey()).intValue()));
            sum = sum == null ? f : sum.plus(f);
        }
        return (F)(sum != null ? sum : (Field)this._zero);
    }

    @Override
    public SparseVector<F> copy() {
        SparseVector<Field> V = SparseVector.newInstance(this._dimension, (Field)this._zero.copy());
        for (Map.Entry<Index, F> e : this._elements.entrySet()) {
            V._elements.put(e.getKey(), (Field)((Field)e.getValue()).copy());
        }
        return V;
    }

    static <F extends Field<F>> SparseVector<F> newInstance(int dimension, F zero) {
        SparseVector V = FACTORY.object();
        V._dimension = dimension;
        V._zero = zero;
        return V;
    }

    private SparseVector() {
    }
}

