/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.physics.amount;

import java.io.IOException;
import java.text.ParseException;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javolution.context.LocalContext;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.jscience.physics.amount.Amount;

public abstract class AmountFormat
extends TextFormat<Amount<?>> {
    private static final LocalContext.Reference<AmountFormat> CURRENT = new LocalContext.Reference<PlusMinusError>(new PlusMinusError(2));

    protected AmountFormat() {
    }

    public static AmountFormat getInstance() {
        return CURRENT.get();
    }

    public static void setInstance(AmountFormat format) {
        CURRENT.set(format);
    }

    public static AmountFormat getPlusMinusErrorInstance(int digitsInError) {
        return new PlusMinusError(digitsInError);
    }

    public static AmountFormat getBracketErrorInstance(int digitsInError) {
        return new BracketError(digitsInError);
    }

    public static AmountFormat getExactDigitsInstance() {
        return new ExactDigitsOnly();
    }

    private static Appendable formatMoney(Amount<Money> arg0, Appendable arg1) throws IOException {
        Currency currency = (Currency)arg0.getUnit();
        int fraction = currency.getDefaultFractionDigits();
        if (fraction == 0) {
            long amount = arg0.longValue(currency);
            TypeFormat.format(amount, arg1);
        } else if (fraction == 2) {
            long amount = MathLib.round(arg0.doubleValue(arg0.getUnit()) * 100.0);
            TypeFormat.format(amount / 100L, arg1);
            arg1.append('.');
            arg1.append((char)(48L + amount % 100L / 10L));
            arg1.append((char)(48L + amount % 10L));
        } else {
            throw new UnsupportedOperationException();
        }
        arg1.append(' ');
        return UnitFormat.getInstance().format(currency, arg1);
    }

    private static class ExactDigitsOnly
    extends AmountFormat {
        private ExactDigitsOnly() {
        }

        @Override
        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format(arg0.getExactValue(), arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor(MathLib.log10(MathLib.abs(value)));
            int log10Error = (int)MathLib.floor(MathLib.log10(error));
            int digits = log10Value - log10Error - 1;
            boolean scientific = MathLib.abs(value) >= 1000000.0 || MathLib.abs(value) < 1.0E-6;
            boolean showZeros = true;
            TypeFormat.format(value, digits, scientific, showZeros, arg1);
            arg1.append(' ');
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        @Override
        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            throw new UnsupportedOperationException("This format should not be used for parsing (not enough information on the error");
        }
    }

    private static class BracketError
    extends AmountFormat {
        private int _errorDigits;

        private BracketError(int errorDigits) {
            this._errorDigits = errorDigits;
        }

        @Override
        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            int endMantissa;
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format(arg0.getExactValue(), arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor(MathLib.log10(MathLib.abs(value)));
            int log10Error = (int)MathLib.floor(MathLib.log10(error));
            int digits = log10Value - log10Error - 1;
            digits = MathLib.max(1, digits + this._errorDigits);
            boolean scientific = MathLib.abs(value) >= 1000000.0 || MathLib.abs(value) < 1.0E-6;
            boolean showZeros = true;
            TextBuilder tb = TextBuilder.newInstance();
            TypeFormat.format(value, digits, scientific, showZeros, tb);
            for (endMantissa = 0; endMantissa < tb.length() && tb.charAt(endMantissa) != 'E'; ++endMantissa) {
            }
            int bracketError = (int)(error * MathLib.toDoublePow10(1L, -log10Error + this._errorDigits - 1));
            tb.insert(endMantissa, Text.valueOf('[').plus(Text.valueOf(bracketError)).plus(Character.valueOf(']')));
            arg1.append(tb);
            arg1.append(' ');
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        @Override
        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            throw new UnsupportedOperationException("Not supported yet");
        }
    }

    private static class PlusMinusError
    extends AmountFormat {
        private int _errorDigits;

        private PlusMinusError(int errorDigits) {
            this._errorDigits = errorDigits;
        }

        @Override
        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format(arg0.getExactValue(), arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor(MathLib.log10(MathLib.abs(value)));
            int log10Error = (int)MathLib.floor(MathLib.log10(error));
            int digits = log10Value - log10Error - 1;
            digits = MathLib.max(1, digits + this._errorDigits);
            boolean scientific = MathLib.abs(value) >= 1000000.0 || MathLib.abs(value) < 1.0E-6;
            boolean showZeros = false;
            arg1.append('(');
            TypeFormat.format(value, digits, scientific, showZeros, arg1);
            arg1.append(" \u00b1 ");
            scientific = MathLib.abs(error) >= 1000000.0 || MathLib.abs(error) < 1.0E-6;
            showZeros = true;
            TypeFormat.format(error, this._errorDigits, scientific, showZeros, arg1);
            arg1.append(") ");
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        @Override
        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            int start = arg1.getIndex();
            try {
                arg1.skip('(', arg0);
                long value = TypeFormat.parseLong(arg0, 10, arg1);
                if (arg0.charAt(arg1.getIndex()) == ' ') {
                    arg1.skip(' ', arg0);
                    Unit<? extends Quantity> unit = UnitFormat.getInstance().parseProductUnit(arg0, arg1);
                    return Amount.valueOf(value, unit);
                }
                arg1.setIndex(start);
                double amount = TypeFormat.parseDouble(arg0, arg1);
                arg1.skip(' ', arg0);
                double error = 0.0;
                if (arg0.charAt(arg1.getIndex()) == '\u00b1') {
                    arg1.skip('\u00b1', arg0);
                    arg1.skip(' ', arg0);
                    error = TypeFormat.parseDouble(arg0, arg1);
                }
                arg1.skip(')', arg0);
                arg1.skip(' ', arg0);
                Unit<? extends Quantity> unit = UnitFormat.getInstance().parseProductUnit(arg0, arg1);
                return Amount.valueOf(amount, error, unit);
            }
            catch (ParseException e) {
                arg1.setIndex(start);
                arg1.setErrorIndex(e.getErrorOffset());
                return null;
            }
        }
    }
}

