/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;
import tools.descartes.dlim.reader.ArrivalRateReader;

public class PlotArrivalRateFileDialog
extends TitleAreaDialog {
    private static final String PLOT_STORE_ID = "dlim.arrivalratefileplot";
    private Text txtFilePathText;
    private Text offsetText;
    private double offset = 0.0;
    private boolean canceled = false;
    private List<ArrivalRateTuple> arrivalRateList;

    public PlotArrivalRateFileDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Plot Arrival Rate File for comparison.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createOffsetParameterField(columnContainer);
        this.createTxtFilePathField(columnContainer);
        return dialogContainer;
    }

    private void createOffsetParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Model start offset within arrival rate file: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.offsetText = new Text(gridContainer, 2048);
        this.offsetText.setText(String.valueOf(this.offset));
        this.offsetText.setLayoutData((Object)parameterFieldData);
    }

    private void createTxtFilePathField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Arrival Rate File: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.txtFilePathText = new Text(gridContainer, 2048);
        this.txtFilePathText.setText(ProjectManager.retrieveStringFromPreferences(PLOT_STORE_ID));
        this.txtFilePathText.setLayoutData((Object)parameterFieldData);
        Button fileDialogButton = new Button(gridContainer, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlotArrivalRateFileDialog.this.getParentShell(), 4096);
                String[] filterNames = new String[]{"Arrival Rate files", "All Files"};
                String[] filterExtensions = new String[]{"*.csv;*.txt", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Select Arrival Rate File");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    PlotArrivalRateFileDialog.this.txtFilePathText.setText(newPath);
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Plot Arrival Rate File");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.offset = Double.parseDouble(this.offsetText.getText().trim());
            if (this.offset < 0.0) {
                this.setMessage("Offset must not be negative.", 3);
                error = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Offset must be a number.", 3);
            error = true;
        }
        String tmpFilePath = this.txtFilePathText.getText().trim();
        Path filePath = new Path(tmpFilePath);
        try {
            if (!error) {
                this.arrivalRateList = ArrivalRateReader.readFileToList((String)filePath.toString(), (double)this.offset);
            }
        }
        catch (IOException iOException) {
            this.setMessage("Error reading file. Does it exist?", 3);
            error = true;
        }
        if (!error) {
            ProjectManager.saveStringToPreferences(PLOT_STORE_ID, tmpFilePath);
            super.okPressed();
        }
    }

    public List<ArrivalRateTuple> getArrivalRateList() {
        return this.arrivalRateList;
    }
}

