/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;

public class SelectExtractorDialog
extends TitleAreaDialog {
    private static final String EXTRACTED_STORE_ID = "dlim.extractordialogstorepath";
    private List exporterList;
    private Text arrivalRateFilePathText;
    private Text offsetText;
    private String[] labels;
    private int selectedIndex = 0;
    private double offset = 0.0;
    private String arrivalRateFilePath = "";
    private boolean canceled = false;

    public SelectExtractorDialog(Shell parentShell, String[] labels) {
        super(parentShell);
        this.labels = labels;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle("Extract model Sequence from an existing arrival rate trace.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new GridLayout(1, false));
        GridData parentData = new GridData();
        parentData.grabExcessHorizontalSpace = true;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        parentData.verticalAlignment = 4;
        columnContainer.setLayoutData((Object)parentData);
        this.createOffsetParameterField(columnContainer);
        this.createTxtFilePathField(columnContainer);
        this.exporterList = new List(columnContainer, 2048);
        String[] stringArray = this.labels;
        int n = this.labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            this.exporterList.add(label);
            ++n2;
        }
        this.exporterList.select(0);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.horizontalAlignment = 4;
        textData.verticalAlignment = 4;
        this.exporterList.setLayoutData((Object)textData);
        return dialogContainer;
    }

    private void createTxtFilePathField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Arrival Rate File: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.arrivalRateFilePathText = new Text(gridContainer, 2048);
        this.arrivalRateFilePathText.setText(ProjectManager.retrieveStringFromPreferences(EXTRACTED_STORE_ID));
        this.arrivalRateFilePathText.setLayoutData((Object)parameterFieldData);
        Button fileDialogButton = new Button(gridContainer, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SelectExtractorDialog.this.getParentShell(), 4096);
                String[] filterNames = new String[]{"Arrival Rate files", "All Files"};
                String[] filterExtensions = new String[]{"*.csv;*.txt", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Select Arrival Rate File");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    SelectExtractorDialog.this.arrivalRateFilePathText.setText(newPath);
                }
            }
        });
    }

    private void createOffsetParameterField(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label parameterFieldLabel = new Label(container, 0);
        parameterFieldLabel.setText("Model start offset within arrival rate file: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.offsetText = new Text(container, 2048);
        this.offsetText.setText(String.valueOf(this.offset));
        this.offsetText.setLayoutData((Object)parameterFieldData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Extract Sequence");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        this.selectedIndex = this.exporterList.getSelectionIndex();
        if (this.selectedIndex < 0) {
            this.setMessage("Please select an Extractor.", 3);
            error = true;
        }
        try {
            this.offset = Double.parseDouble(this.offsetText.getText().trim());
            if (this.offset < 0.0) {
                this.setMessage("Offset must not be negative.", 3);
                error = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Offset must be a number.", 3);
            error = true;
        }
        this.arrivalRateFilePath = this.arrivalRateFilePathText.getText().trim();
        Path filePath = new Path(this.arrivalRateFilePath);
        try {
            BufferedReader br = new BufferedReader(new FileReader(filePath.toString()));
            br.close();
        }
        catch (IOException iOException) {
            this.setMessage("Error reading file. Does it exist?", 3);
            error = true;
        }
        if (!error) {
            ProjectManager.saveStringToPreferences(EXTRACTED_STORE_ID, this.arrivalRateFilePath);
            this.arrivalRateFilePath = filePath.toString();
            super.okPressed();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public double getOffset() {
        return this.offset;
    }

    public String getArrivalRateFilePath() {
        return this.arrivalRateFilePath;
    }

    protected Point getInitialSize() {
        return new Point(480, 400);
    }
}

