/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import tools.descartes.dlim.generator.ui.utils.DlimFileUtils;
import tools.descartes.dlim.presentation.DlimEditorPlugin;

public class ProjectManager {
    private static final String DLIM_EDITOR_PREFERENCES_ID = "tools.descartes.dlim.editor.preferences";
    private static final String EDITOR_NODE_PREFERENCES_ID = "editor";
    private IProject currentProject = null;

    public ProjectManager(ISelection selection) {
        URI uri;
        EObject modelElement;
        IResource selectedResource = DlimFileUtils.getResourceFromSelection((ISelection)selection);
        if (selectedResource == null && (modelElement = DlimFileUtils.getEObjectFromSelection((ISelection)selection)) != null && (uri = modelElement.eResource().getURI()).isPlatformResource()) {
            selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
        }
        if (selectedResource != null) {
            this.currentProject = selectedResource.getProject();
        }
    }

    public ProjectManager(IResource resource) {
        if (resource != null) {
            this.currentProject = resource.getProject();
        }
    }

    public String getProjectPath() {
        return this.currentProject.getLocation().toString();
    }

    public void refreshProject() {
        try {
            this.currentProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            DlimEditorPlugin.INSTANCE.log(new Status(4, "tools.descartes.dlim.presentation.DlimEditorPlugin", "Failed to refresh Project", (Throwable)e));
        }
    }

    public static void saveStringToPreferences(String key, String value) {
        IEclipsePreferences dlimPrefs = InstanceScope.INSTANCE.getNode(DLIM_EDITOR_PREFERENCES_ID);
        Preferences filePathPref = dlimPrefs.node(EDITOR_NODE_PREFERENCES_ID);
        filePathPref.put(key, value);
        try {
            dlimPrefs.flush();
        }
        catch (BackingStoreException e) {
            DlimEditorPlugin.INSTANCE.log(new Status(2, "tools.descartes.dlim.presentation.DlimEditorPlugin", "Could not save property: " + key, (Throwable)e));
        }
    }

    public static String retrieveStringFromPreferences(String key) {
        IEclipsePreferences dlimPrefs = InstanceScope.INSTANCE.getNode(DLIM_EDITOR_PREFERENCES_ID);
        Preferences filePathPref = dlimPrefs.node(EDITOR_NODE_PREFERENCES_ID);
        return filePathPref.get(key, "");
    }
}

