/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.generator.editor.wizards.DlimModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimTrendModelWizardPage;

public class DlimSeasonalModelWizardPage
extends DlimModelWizardPage {
    private Text periodText;
    private Text numPeaksText;
    private Text baseText;
    private Text innerBaseText;
    private Text firstPeakText;
    private Text lastPeakText;
    private Text peakIntervalText;
    private Combo shapeCombo;
    private double period = 24.0;
    private int numPeaks = 0;
    private double base = 0.0;
    private double innerBase = 0.0;
    private double firstPeak = 10.0;
    private double lastPeak = 10.0;
    private double peakInterval = 12.0;

    protected DlimSeasonalModelWizardPage(String pageName, Sequence rootSequence) {
        super(pageName, rootSequence);
    }

    @Override
    protected void fillInteractiveArea(Composite interactiveArea) {
        Composite parent = new Composite(interactiveArea, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.createDurationField(parent);
        this.createNumPeaksField(parent);
        this.createBaseField(parent);
        this.createInnerBaseField(parent);
        this.createfirstPeakField(parent);
        this.createlastPeakField(parent);
        this.createPeakIntervalField(parent);
        Composite formSelectionComposite = new Composite(interactiveArea, 0);
        GridLayout formSelectionLayout = new GridLayout(2, false);
        formSelectionLayout.marginWidth = 5;
        formSelectionLayout.marginHeight = 5;
        formSelectionLayout.verticalSpacing = 0;
        formSelectionLayout.horizontalSpacing = 0;
        formSelectionComposite.setLayout((Layout)formSelectionLayout);
        this.createFormSelectionField(formSelectionComposite);
    }

    private void createDurationField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Period: ");
        fieldLabel.setAlignment(131072);
        this.periodText = new Text(parent, 2048);
        this.periodText.setText("" + this.period);
        this.addValidationListener(this.periodText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.periodText.setLayoutData((Object)textData);
    }

    private void createNumPeaksField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Number of Peaks: ");
        fieldLabel.setAlignment(131072);
        this.numPeaksText = new Text(parent, 2048);
        this.numPeaksText.setText("" + this.numPeaks);
        this.addValidationListener(this.numPeaksText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.numPeaksText.setLayoutData((Object)textData);
    }

    private void createBaseField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Base Arrival Rate Level: ");
        fieldLabel.setAlignment(131072);
        this.baseText = new Text(parent, 2048);
        this.baseText.setText("" + this.base);
        this.addValidationListener(this.baseText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.baseText.setLayoutData((Object)textData);
    }

    private void createfirstPeakField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    First Peak Arrival Rate: ");
        fieldLabel.setAlignment(131072);
        this.firstPeakText = new Text(parent, 2048);
        this.firstPeakText.setText("" + this.firstPeak);
        this.firstPeakText.setEnabled(false);
        this.addValidationListener(this.firstPeakText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.firstPeakText.setLayoutData((Object)textData);
    }

    private void createlastPeakField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Last Peak Arrival Rate: ");
        fieldLabel.setAlignment(131072);
        this.lastPeakText = new Text(parent, 2048);
        this.lastPeakText.setText("" + this.lastPeak);
        this.lastPeakText.setEnabled(false);
        this.addValidationListener(this.lastPeakText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.lastPeakText.setLayoutData((Object)textData);
    }

    private void createInnerBaseField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Base Arrival Rate Level between Peaks: ");
        fieldLabel.setAlignment(131072);
        this.innerBaseText = new Text(parent, 2048);
        this.innerBaseText.setText("" + this.innerBase);
        this.addValidationListener(this.innerBaseText);
        this.innerBaseText.setEnabled(false);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.innerBaseText.setLayoutData((Object)textData);
    }

    private void createPeakIntervalField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Interval containing Peaks: ");
        fieldLabel.setAlignment(131072);
        this.peakIntervalText = new Text(parent, 2048);
        this.peakIntervalText.setText("12.0");
        this.addValidationListener(this.peakIntervalText);
        this.peakIntervalText.setEnabled(false);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.peakIntervalText.setLayoutData((Object)textData);
    }

    private void createFormSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Select Seasonal Shape: ");
        fieldLabel.setAlignment(131072);
        this.shapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.shapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.shapeCombo.add(name);
        }
        this.shapeCombo.select(0);
        this.addValidationListener(this.shapeCombo);
    }

    @Override
    protected boolean validatePage() {
        try {
            this.period = Double.parseDouble(this.periodText.getText().trim());
            if (this.period <= 0.0) {
                this.setMessage("Period must be > 0.", 3);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Period must be a number.", 3);
            return false;
        }
        try {
            this.numPeaks = Integer.parseInt(this.numPeaksText.getText().trim());
            if (this.firstPeakText != null && this.innerBaseText != null && this.lastPeakText != null && this.peakIntervalText != null) {
                if (this.numPeaks > 0) {
                    this.firstPeakText.setEnabled(true);
                } else {
                    this.firstPeakText.setEnabled(false);
                }
                if (this.numPeaks > 1) {
                    this.innerBaseText.setEnabled(true);
                    this.lastPeakText.setEnabled(true);
                    this.peakIntervalText.setEnabled(true);
                } else {
                    this.innerBaseText.setEnabled(false);
                    this.lastPeakText.setEnabled(false);
                    this.peakIntervalText.setEnabled(false);
                }
            }
            if (this.numPeaks < 0) {
                this.setMessage("Number of Peaks must be >= 0.", 3);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Number of Peaks must be an Integer.", 3);
            return false;
        }
        try {
            this.base = Double.parseDouble(this.baseText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Base must be a number.", 3);
            return false;
        }
        try {
            if (this.innerBaseText.isEnabled()) {
                this.innerBase = Double.parseDouble(this.innerBaseText.getText().trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Base between Peaks must be a number.", 3);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        try {
            if (this.firstPeakText.isEnabled()) {
                this.firstPeak = Double.parseDouble(this.firstPeakText.getText().trim());
                if (this.firstPeak < this.base) {
                    this.setMessage("First Peak Arrival Rate must not be smaller than the base level.", 3);
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("First Peak Arrival Rate must be a number.", 3);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        try {
            if (this.lastPeakText.isEnabled()) {
                this.lastPeak = Double.parseDouble(this.lastPeakText.getText().trim());
                if (this.lastPeak < this.base) {
                    this.setMessage("Last Peak Arrival Rate must not be smaller than the base level.", 3);
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Last Peak Arrival Rate must be a number.", 3);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        try {
            if (this.peakIntervalText.isEnabled()) {
                this.peakInterval = Double.parseDouble(this.peakIntervalText.getText().trim());
                if (this.peakInterval <= 0.0 || this.peakInterval >= this.period) {
                    this.setMessage("Peak Interval must range between 0 and Period (" + this.period + ")", 3);
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Peak Interval must be a number.", 3);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        this.setMessage(this.getDescription());
        this.populateModel();
        this.updatePlot();
        this.preSetTrends();
        return true;
    }

    private void populateModel() {
        this.getRootSequence().getSequenceFunctionContainers().clear();
        this.getRootSequence().setTerminateAfterLoops(1);
        this.getRootSequence().setTerminateAfterTime(0.0);
        DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
        if (this.numPeaks == 0) {
            TimeDependentFunctionContainer constantElement = factory.createTimeDependentFunctionContainer();
            constantElement.setName("constantSeasonal");
            constantElement.setDuration(this.period);
            Constant constant = factory.createConstant();
            constant.setConstant(this.base);
            constantElement.setFunction((Function)constant);
            this.getRootSequence().getSequenceFunctionContainers().add((Object)constantElement);
        }
        try {
            if (this.numPeaks > 0) {
                TimeDependentFunctionContainer trendElement;
                double currentArrivalRate = this.base;
                int i = 0;
                while (i < (this.numPeaks - 1) * 2 + 1) {
                    trendElement = factory.createTimeDependentFunctionContainer();
                    trendElement.setName("seasonal" + i);
                    if (i == 0) {
                        trendElement.setDuration((this.period - this.peakInterval) / 2.0);
                        if (this.numPeaks == 1) {
                            trendElement.setDuration(this.period / 2.0);
                        }
                    } else {
                        trendElement.setDuration(this.peakInterval / ((double)(this.numPeaks - 1) * 2.0));
                    }
                    Trend trend = (Trend)factory.create((EClass)DlimPackage.eINSTANCE.getEClassifier(this.shapeCombo.getText().trim()));
                    trend.setFunctionOutputAtStart(currentArrivalRate);
                    currentArrivalRate = this.numPeaks == 1 ? this.firstPeak : (i % 2 == 0 ? this.firstPeak + (this.lastPeak - this.firstPeak) * (double)(i / 2) / (double)(this.numPeaks - 1) : this.innerBase);
                    trend.setFunctionOutputAtEnd(currentArrivalRate);
                    trendElement.setFunction((Function)trend);
                    this.getRootSequence().getSequenceFunctionContainers().add((Object)trendElement);
                    ++i;
                }
                Trend trend = (Trend)factory.create((EClass)DlimPackage.eINSTANCE.getEClassifier(this.shapeCombo.getText().trim()));
                trend.setFunctionOutputAtStart(currentArrivalRate);
                trend.setFunctionOutputAtEnd(this.base);
                trendElement = factory.createTimeDependentFunctionContainer();
                trendElement.setDuration((this.period - this.peakInterval) / 2.0);
                if (this.numPeaks == 1) {
                    trendElement.setDuration(this.period / 2.0);
                }
                trendElement.setName("seasonal" + this.numPeaks * 2);
                trendElement.setFunction((Function)trend);
                this.getRootSequence().getSequenceFunctionContainers().add((Object)trendElement);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void preSetTrends() {
        if (this.getDlimModelWizard().getTrendPage() instanceof DlimTrendModelWizardPage) {
            DlimTrendModelWizardPage page = this.getDlimModelWizard().getTrendPage();
            double highestPeakTime = 0.0;
            if (this.firstPeak > 0.0 || this.lastPeak > 0.0) {
                highestPeakTime = this.numPeaks == 1 && this.firstPeak > 0.0 ? this.getRootSequence().getLoopDuration() / 2.0 : (this.firstPeak == this.lastPeak && this.numPeaks % 2 == 1 ? this.getRootSequence().getLoopDuration() / 2.0 : (this.lastPeak > this.firstPeak ? (this.getRootSequence().getLoopDuration() + this.peakInterval) / 2.0 : (this.getRootSequence().getLoopDuration() - this.peakInterval) / 2.0));
            }
            page.calculatePeriodDuration(highestPeakTime, this.period);
        }
    }

    public String getSeasonalShape() {
        return this.shapeCombo.getText();
    }

    @Override
    protected void parseParameters(HLDlimParameterContainer container) {
        this.periodText.setText("" + container.getSeasonalPeriod());
        this.numPeaksText.setText("" + container.getPeakNum());
        this.baseText.setText("" + container.getBase());
        this.innerBaseText.setText("" + container.getInnerBase());
        this.firstPeakText.setText("" + container.getFirstPeak());
        this.lastPeakText.setText("" + container.getLastPeak());
        this.peakIntervalText.setText("" + container.getPeakIntervalWidth());
        this.shapeCombo.setText(container.getSeasonalShape());
        this.period = container.getSeasonalPeriod();
        this.numPeaks = container.getPeakNum();
        this.base = container.getBase();
        this.innerBase = container.getInnerBase();
        this.firstPeak = container.getFirstPeak();
        this.lastPeak = container.getLastPeak();
        this.peakInterval = container.getPeakIntervalWidth();
        this.preSetTrends();
    }
}

