/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.ModelExtractor;
import tools.descartes.dlim.extractor.utils.Autocorrelation;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public class LaunchPeriodicExtractionDialog
extends TitleAreaDialog {
    private Text seasonalPeriodText;
    private org.eclipse.swt.widgets.List seasonalsPerTrendList;
    private Text seasonalsPerTrend1Text;
    private Text seasonalsPerTrend2Text;
    private Button addToListButton;
    private Button extractNoiseButton;
    private Button autocorrelationButton;
    private Combo seasonalShapeCombo;
    private Combo trendShapeCombo;
    private Combo operatorCombo;
    private boolean seasonalsPerTrend1Valid = false;
    private boolean seasonalsPerTrend2Valid = false;
    private double seasonalPeriod = 24.0;
    private ArrayList<int[]> seasonalsPerTrendContainer = new ArrayList();
    private String seasonalShape = "SinTrend";
    private String trendShape = "SinTrend";
    private String operatorLiteral = "MULT";
    private boolean extractNoise = false;
    private boolean canceled = false;
    private Sequence rootSequence;
    private List<ArrivalRateTuple> readArrivalRates;

    public LaunchPeriodicExtractionDialog(Shell parentShell, Sequence rootSequence, List<ArrivalRateTuple> readArrivalRates) {
        super(parentShell);
        this.rootSequence = rootSequence;
        this.readArrivalRates = readArrivalRates;
    }

    public void create() {
        super.create();
        this.setTitle("Extract Sequence from Arrival Rate File");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new GridLayout(1, false));
        Composite gridComposite = new Composite(columnContainer, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        gridComposite.setLayout((Layout)gridLayout);
        this.createSeasonalPeriodParameterField(gridComposite);
        this.createExtractNoiseCheckBox(gridComposite);
        Composite trendListComposite = new Composite(columnContainer, 0);
        trendListComposite.setLayout((Layout)new GridLayout(1, false));
        this.createTrendList(trendListComposite);
        this.createListControlField(trendListComposite);
        Composite formSelectionComposite = new Composite(columnContainer, 0);
        GridLayout formSelectionLayout = new GridLayout(2, false);
        formSelectionComposite.setLayout((Layout)formSelectionLayout);
        this.createSeasonalShapeSelectionField(formSelectionComposite);
        this.createTrendShapeSelectionField(formSelectionComposite);
        this.createOperatorSelectionField(formSelectionComposite);
        return dialogContainer;
    }

    private void createTrendList(Composite parent) {
        GridData parentData = new GridData();
        parentData.grabExcessHorizontalSpace = true;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        parentData.verticalAlignment = 4;
        parentData.heightHint = 160;
        parent.setLayoutData((Object)parentData);
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Piece-wise Trend per Seasonals: ");
        fieldLabel.setAlignment(16384);
        this.seasonalsPerTrendList = new org.eclipse.swt.widgets.List(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.horizontalAlignment = 4;
        textData.verticalAlignment = 4;
        this.seasonalsPerTrendList.setLayoutData((Object)textData);
        this.seasonalsPerTrendList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrendContainer.remove(LaunchPeriodicExtractionDialog.this.seasonalsPerTrendList.getSelectionIndex());
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrendList.remove(LaunchPeriodicExtractionDialog.this.seasonalsPerTrendList.getSelectionIndex());
                }
            }
        });
    }

    private void createListControlField(Composite container) {
        Composite parent = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 2;
        parent.setLayout((Layout)gridLayout);
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Add Trend with following piece-wise durations: ");
        fieldLabel.setAlignment(131072);
        this.seasonalsPerTrend1Text = new Text(parent, 2048);
        this.seasonalsPerTrend1Text.setText("");
        GridData textData1 = new GridData();
        textData1.grabExcessHorizontalSpace = false;
        textData1.horizontalAlignment = 1;
        textData1.widthHint = 70;
        this.seasonalsPerTrend1Text.setLayoutData((Object)textData1);
        this.seasonalsPerTrend2Text = new Text(parent, 2048);
        this.seasonalsPerTrend2Text.setText("");
        GridData textData2 = new GridData();
        textData2.grabExcessHorizontalSpace = false;
        textData2.horizontalAlignment = 1;
        textData2.widthHint = 70;
        this.seasonalsPerTrend2Text.setLayoutData((Object)textData2);
        this.addToListButton = new Button(parent, 8);
        this.addToListButton.setText("Add");
        this.addToListButton.setEnabled(false);
        this.seasonalsPerTrend1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    Integer.parseInt(LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Text.getText().trim());
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Valid = true;
                    if (LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Valid && LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Valid) {
                        LaunchPeriodicExtractionDialog.this.addToListButton.setEnabled(true);
                    }
                }
                catch (NumberFormatException exception) {
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Valid = false;
                    LaunchPeriodicExtractionDialog.this.addToListButton.setEnabled(false);
                }
            }
        });
        this.seasonalsPerTrend2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    Integer.parseInt(LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Text.getText().trim());
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Valid = true;
                    if (LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Valid && LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Valid) {
                        LaunchPeriodicExtractionDialog.this.addToListButton.setEnabled(true);
                    }
                }
                catch (NumberFormatException exception) {
                    LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Valid = false;
                    LaunchPeriodicExtractionDialog.this.addToListButton.setEnabled(false);
                }
            }
        });
        this.addToListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            private void handleEvent(SelectionEvent e) {
                int[] seasonalsPerTrend = new int[]{Integer.parseInt(LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Text.getText().trim()), Integer.parseInt(LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Text.getText().trim())};
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrendContainer.add(seasonalsPerTrend);
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrendList.add(" " + seasonalsPerTrend[0] + " , " + seasonalsPerTrend[1]);
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Text.setText("");
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Text.setText("");
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrend1Valid = false;
                LaunchPeriodicExtractionDialog.this.seasonalsPerTrend2Valid = false;
                LaunchPeriodicExtractionDialog.this.addToListButton.setEnabled(false);
            }
        });
    }

    private void createSeasonalPeriodParameterField(Composite container) {
        Label parameterFieldLabel = new Label(container, 0);
        parameterFieldLabel.setText("    Seasonal Period: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.seasonalPeriodText = new Text(container, 2048);
        this.seasonalPeriodText.setText(String.valueOf(this.seasonalPeriod));
        this.seasonalPeriodText.setLayoutData((Object)parameterFieldData);
        this.autocorrelationButton = new Button(container, 8);
        this.autocorrelationButton.setText("Detect Period");
        this.autocorrelationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            private void selected() {
                double period = Autocorrelation.seasonalPeriodUsingAutocorrelation(LaunchPeriodicExtractionDialog.this.readArrivalRates);
                LaunchPeriodicExtractionDialog.this.setSeasonalPeriod(period);
            }
        });
    }

    private void createExtractNoiseCheckBox(Composite container) {
        Label fieldLabel = new Label(container, 0);
        fieldLabel.setText("          ");
        this.extractNoiseButton = new Button(container, 32);
        this.extractNoiseButton.setText("Extract Noise");
        this.extractNoiseButton.setSelection(false);
    }

    private void createSeasonalShapeSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Seasonal Shape: ");
        fieldLabel.setAlignment(131072);
        this.seasonalShapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.seasonalShapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.seasonalShapeCombo.add(name);
        }
        this.seasonalShapeCombo.select(this.seasonalShapeCombo.getItemCount() - 1);
    }

    private void createTrendShapeSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Trend Shape: ");
        fieldLabel.setAlignment(131072);
        this.trendShapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.trendShapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.trendShapeCombo.add(name);
        }
        this.trendShapeCombo.select(this.trendShapeCombo.getItemCount() - 1);
    }

    private void createOperatorSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Trend Operator: ");
        fieldLabel.setAlignment(131072);
        this.operatorCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.operatorCombo.setLayoutData((Object)textData);
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator op = operatorArray[n2];
            this.operatorCombo.add(op.getLiteral());
            ++n2;
        }
        this.operatorCombo.setText("MULT");
    }

    private Collection<String> getInitialTrendNames() {
        ArrayList<String> initialObjectNames = new ArrayList<String>();
        for (EClassifier eClassifier : DlimPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !DlimPackage.eINSTANCE.getTrend().isSuperTypeOf(eClass)) continue;
            initialObjectNames.add(eClass.getName());
        }
        Collections.sort(initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        return initialObjectNames;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Extract Sequence");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.seasonalPeriod = Double.parseDouble(this.seasonalPeriodText.getText().trim());
            if (this.seasonalPeriod <= 0.0) {
                this.setMessage("Seasonal Period must be greater than 0.", 3);
                error = true;
            }
        }
        catch (NumberFormatException e) {
            this.setMessage("Seasonal Period must be a number.", 3);
            error = true;
        }
        this.extractNoise = this.extractNoiseButton.getSelection();
        this.seasonalShape = this.seasonalShapeCombo.getText().trim();
        this.trendShape = this.trendShapeCombo.getText().trim();
        this.operatorLiteral = this.operatorCombo.getText().trim();
        if (!error) {
            try {
                ModelExtractor.extractSequenceFromArrivalRateFilePeriodic((Sequence)this.rootSequence, this.readArrivalRates, (double)this.getSeasonalPeriod(), this.getSeasonalsPerTrend(), (String)this.getSeasonalShape(), (String)this.getTrendShape(), (String)this.getOperatorLiteral(), (boolean)this.isExtractNoise());
                super.okPressed();
            }
            catch (CalibrationException e) {
                this.setMessage("Model Extraction Error: " + e.getMessage(), 3);
            }
        }
    }

    public double getSeasonalPeriod() {
        return this.seasonalPeriod;
    }

    protected void setSeasonalPeriod(double seasonalPeriod) {
        this.seasonalPeriod = seasonalPeriod;
        this.seasonalPeriodText.setText(String.valueOf(seasonalPeriod));
    }

    public ArrayList<int[]> getSeasonalsPerTrend() {
        return this.seasonalsPerTrendContainer;
    }

    public String getSeasonalShape() {
        return this.seasonalShape;
    }

    public String getTrendShape() {
        return this.trendShape;
    }

    public String getOperatorLiteral() {
        return this.operatorLiteral;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    public boolean isExtractNoise() {
        return this.extractNoise;
    }
}

