/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.List;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import tools.descartes.dlim.extractor.ModelExtractor;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public final class Autocorrelation {
    private static final int DUMMY_PERIOD = 72;
    private static final int MAX_LAGS_TO_CONSIDER = 200;

    private Autocorrelation() {
    }

    public static double seasonalPeriodUsingAutocorrelation(List<ArrivalRateTuple> arrivalRates) {
        CorrelationResult result = Autocorrelation.getPeriodFromAutocorr(arrivalRates, new CorrelationResult(0, new double[200]));
        if (Autocorrelation.periodGood(result.getCorrSaver(), result.getMaxLag())) {
            return result.getMaxLag();
        }
        List<ArrivalRateTuple> arrListGauss = arrivalRates;
        ModelExtractor.reduceArrivalRateListNoise(arrListGauss, (double)72.0);
        result = Autocorrelation.getPeriodFromAutocorr(arrListGauss, result);
        if (Autocorrelation.periodGood(result.getCorrSaver(), result.getMaxLag())) {
            return result.getMaxLag();
        }
        return 0.0;
    }

    private static CorrelationResult getPeriodFromAutocorr(List<ArrivalRateTuple> arrList, CorrelationResult previousResult) {
        double[] corrSaver = previousResult.getCorrSaver();
        double[] arrRateArray = new double[arrList.size()];
        int j = 0;
        for (ArrivalRateTuple art : arrList) {
            arrRateArray[j] = art.getArrivalRate();
            ++j;
        }
        double[] arrRateArrayLag = new double[arrList.size()];
        int k = 0;
        while (k < 200) {
            double correlationTraceLagTrace;
            int l = 0;
            for (ArrivalRateTuple art : arrList) {
                arrRateArrayLag[(l + k) % arrList.size()] = art.getArrivalRate();
                ++l;
            }
            PearsonsCorrelation corr = new PearsonsCorrelation();
            corrSaver[k] = correlationTraceLagTrace = corr.correlation(arrRateArray, arrRateArrayLag);
            ++k;
        }
        Autocorrelation.findLocalMaxima(corrSaver, 5);
        double maxCorr = 0.0;
        int lagOfMax = 0;
        int k2 = 10;
        while (k2 < corrSaver.length) {
            if (corrSaver[k2] > maxCorr) {
                maxCorr = corrSaver[k2];
                lagOfMax = k2;
            }
            ++k2;
        }
        System.out.println("maximale Korrelation bei Lag " + lagOfMax + "entspricht " + maxCorr);
        int i = 1;
        while (i < 10) {
            System.out.println("Korrelation bei " + i + "-fachen Lag");
            System.out.println("corrSaver[lagOfMax*" + i + "] =" + " " + corrSaver[lagOfMax * i % corrSaver.length]);
            ++i;
        }
        return new CorrelationResult(lagOfMax, corrSaver);
    }

    private static boolean periodGood(double[] corrSaver, int lagOfMax) {
        if (corrSaver[lagOfMax % corrSaver.length] <= 0.5) {
            return false;
        }
        int k = 2;
        while (k < 6) {
            if (corrSaver[lagOfMax * k % corrSaver.length] <= 0.0) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private static double[][] findLocalMaxima(double[] corrSaver, int range) {
        double[] window = new double[2 * range + 1];
        double[][] lagMax = new double[2][20];
        int r = 0;
        double maxCorr = 0.0;
        int i = range;
        while (i < corrSaver.length - range) {
            int j = 0;
            while (j < window.length) {
                window[j] = corrSaver[i - range + j];
                ++j;
            }
            int n = 0;
            while (n < window.length) {
                if (window[n] > maxCorr) {
                    maxCorr = window[n];
                }
                ++n;
            }
            if (window[range] == maxCorr) {
                lagMax[0][r] = i;
                lagMax[1][r] = maxCorr;
                ++r;
            }
            maxCorr = 0.0;
            ++i;
        }
        return lagMax;
    }

    private static class CorrelationResult {
        private double[] corrSaver;
        private int maxLag;

        public CorrelationResult(int maxLag, double[] corrSaver) {
            this.maxLag = maxLag;
            this.corrSaver = corrSaver;
        }

        public double[] getCorrSaver() {
            return this.corrSaver;
        }

        public int getMaxLag() {
            return this.maxLag;
        }
    }
}

