/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractorHandler;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.extractor.IDlimExtractor;
import tools.descartes.dlim.extractorHandler.ExtractorContainer;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.reader.IDlimArrivalRateReader;

public final class ExtractorHandler {
    public static final String IEXTRACTOR_ID = "tools.descartes.dlim.generator.tools_descartes_dlim_generator_extractors";
    private ArrayList<ExtractorContainer> extractors = new ArrayList();
    private static ExtractorHandler handlerSingleton;

    public static ExtractorHandler getHandlerSingleton() {
        if (handlerSingleton == null) {
            handlerSingleton = new ExtractorHandler();
        }
        return handlerSingleton;
    }

    private ExtractorHandler() {
        if (handlerSingleton == null) {
            handlerSingleton = this;
            this.execute(Platform.getExtensionRegistry());
        }
    }

    @Execute
    private void execute(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IEXTRACTOR_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object extr = e.createExecutableExtension("extractor_class");
                Object read = e.createExecutableExtension("reader_class");
                String label = e.getAttribute("label");
                if (extr instanceof IDlimExtractor && read instanceof IDlimArrivalRateReader) {
                    this.extractors.add(new ExtractorContainer(label, (IDlimExtractor)extr, (IDlimArrivalRateReader)read));
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", ex.getMessage(), (Throwable)ex));
        }
    }

    public String[] getExtractorLabels() {
        String[] labels = new String[this.extractors.size()];
        int i = 0;
        for (ExtractorContainer e : this.extractors) {
            labels[i] = e.getLabel();
            ++i;
        }
        return labels;
    }

    public void executeExtension(final int extractorIndex, final String arrivalRateFilePath, final Sequence rootObject, final double offset) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Exception in client", e));
            }

            public void run() throws Exception {
                IDlimExtractor extractor = ExtractorHandler.this.extractors.get(extractorIndex).getExtractor();
                IDlimArrivalRateReader reader = ExtractorHandler.this.extractors.get(extractorIndex).getReader();
                extractor.extractIntoSequence(rootObject, reader.readFileToList(arrivalRateFilePath, offset));
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

