/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.util;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.AbsoluteSin;
import tools.descartes.dlim.Burst;
import tools.descartes.dlim.ExponentialIncreaseAndDecline;
import tools.descartes.dlim.ExponentialIncreaseLogarithmicDecline;
import tools.descartes.dlim.ExponentialTrend;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.LinearIncreaseAndDecline;
import tools.descartes.dlim.LinearTrend;
import tools.descartes.dlim.LogarithmicTrend;
import tools.descartes.dlim.Noise;
import tools.descartes.dlim.NormalNoise;
import tools.descartes.dlim.Polynomial;
import tools.descartes.dlim.PolynomialFactor;
import tools.descartes.dlim.Seasonal;
import tools.descartes.dlim.Sin;
import tools.descartes.dlim.SinTrend;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.UniformNoise;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ModelEvaluatorUtil;

public class FunctionValueCalculator {
    private JDKRandomGenerator rndGenerator;
    private NormalDistribution nDistribution;
    private String noiseMode = "";

    public FunctionValueCalculator(JDKRandomGenerator rndGenerator, String noiseMode) {
        this.rndGenerator = rndGenerator;
        this.nDistribution = new NormalDistribution((RandomGenerator)rndGenerator, 0.0, 1.0, 1.0E-9);
        this.noiseMode = noiseMode;
    }

    public double getSimpleFunctionValue(Function f, double x) {
        if (f instanceof Polynomial) {
            return this.getPolynomialValue((Polynomial)f, x);
        }
        if (f instanceof Noise) {
            return this.getNoiseValue((Noise)f, x);
        }
        if (f instanceof Seasonal) {
            return this.getSeasonalValue((Seasonal)f, x);
        }
        if (f instanceof Burst) {
            return this.getBurstValue((Burst)f, x);
        }
        if (f instanceof Trend) {
            return this.getTrendValue((Trend)f, x);
        }
        Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Function matches no Category: " + f.toString()));
        return 0.0;
    }

    public void setNoiseMode(String noiseMode) {
        this.noiseMode = noiseMode;
    }

    private double getPolynomialValue(Polynomial f, double x) {
        int index = f.getFactors().size() - 1;
        double value = 0.0;
        for (PolynomialFactor factor : f.getFactors()) {
            value = index == 0 ? (value += factor.getFactor()) : (value += factor.getFactor() * Math.pow(x + factor.getOffset(), index));
            --index;
        }
        return value;
    }

    private double getNoiseValue(Noise f, double x) {
        if (this.noiseMode.contains("dlim:calibration")) {
            return 0.0;
        }
        if (f instanceof UniformNoise) {
            UniformNoise noise = (UniformNoise)f;
            return noise.getMin() + (noise.getMax() - noise.getMin()) * this.rndGenerator.nextDouble();
        }
        if (f instanceof NormalNoise) {
            NormalNoise noise = (NormalNoise)f;
            return noise.getMean() + noise.getStandardDeviation() * this.nDistribution.sample();
        }
        Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Unknown Noise: " + f.toString()));
        return 0.0;
    }

    private double getSeasonalValue(Seasonal f, double x) {
        if (f instanceof Sin) {
            Sin sin = (Sin)f;
            if (f instanceof AbsoluteSin) {
                return sin.getMin() + (sin.getMax() - sin.getMin()) * Math.abs(Math.sin((x + sin.getPhase()) * 2.0 * Math.PI / sin.getPeriod()));
            }
            return sin.getMin() + (sin.getMax() - sin.getMin()) / 2.0 + (sin.getMax() - sin.getMin()) / 2.0 * Math.sin((x + sin.getPhase()) * 2.0 * Math.PI / sin.getPeriod());
        }
        Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Unknown Seasonal: " + f.toString()));
        return 0.0;
    }

    private double getBurstValue(Burst f, double x) {
        if (f instanceof LinearIncreaseAndDecline) {
            LinearIncreaseAndDecline burst = (LinearIncreaseAndDecline)f;
            return this.calculateLinearIncreaseAndDeclineValue(x, burst.getBase(), burst.getPeak(), burst.getPeakTime(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        if (f instanceof ExponentialIncreaseAndDecline) {
            ExponentialIncreaseAndDecline burst = (ExponentialIncreaseAndDecline)f;
            return this.calculateExponentialIncreaseAndDeclineValue(x, burst.getBase(), burst.getPeak(), burst.getPeakTime(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        if (f instanceof ExponentialIncreaseLogarithmicDecline) {
            ExponentialIncreaseLogarithmicDecline burst = (ExponentialIncreaseLogarithmicDecline)f;
            return this.calculateExponentialIncreaseLogarthmicDeclineValue(x, burst.getBase(), burst.getPeak(), burst.getPeakTime(), burst.getLogarithmicOrder(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Unknown Burst: " + f.toString()));
        return 0.0;
    }

    private double getTrendValue(Trend f, double x) {
        if (f instanceof LinearTrend) {
            LinearTrend trend = (LinearTrend)f;
            return trend.getFunctionOutputAtStart() + x * (trend.getFunctionOutputAtEnd() - trend.getFunctionOutputAtStart()) / ModelEvaluatorUtil.getFunctionDuration((Function)f);
        }
        if (f instanceof ExponentialTrend) {
            ExponentialTrend trend = (ExponentialTrend)f;
            return this.calculateExponentialTrendValue(x, trend.getFunctionOutputAtEnd(), trend.getFunctionOutputAtStart(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        if (f instanceof LogarithmicTrend) {
            LogarithmicTrend trend = (LogarithmicTrend)f;
            return this.calculateLogarithmicTrendValue(x, trend.getFunctionOutputAtEnd(), trend.getFunctionOutputAtStart(), trend.getOrder(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        if (f instanceof SinTrend) {
            SinTrend trend = (SinTrend)f;
            return this.calculateSinTrendValue(x, trend.getFunctionOutputAtEnd(), trend.getFunctionOutputAtStart(), ModelEvaluatorUtil.getFunctionDuration((Function)f));
        }
        Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "Unknown Trend: " + f.toString()));
        return 1.0;
    }

    private double calculateLogarithmicTrendValue(double x, double endValue, double startValue, double order, double duration) {
        if (startValue > endValue) {
            double tmpX = Math.abs(x - duration);
            return endValue + (startValue - endValue) * (1.0 / order) * Math.log(tmpX * (Math.exp(order) - 1.0) / duration + 1.0);
        }
        return startValue + (endValue - startValue) * (1.0 / order) * Math.log(x * (Math.exp(order) - 1.0) / duration + 1.0);
    }

    private double calculateSinTrendValue(double x, double endValue, double startValue, double duration) {
        double minValue = startValue;
        double maxValue = endValue;
        double phase = -1.5707963267948966;
        if (startValue > endValue) {
            minValue = endValue;
            maxValue = startValue;
            phase = 1.5707963267948966;
        }
        return minValue + (maxValue - minValue) / 2.0 + (maxValue - minValue) / 2.0 * Math.sin(phase + x * Math.PI / duration);
    }

    private double calculateExponentialTrendValue(double x, double endValue, double startValue, double duration) {
        double offset = 0.0;
        double start = startValue;
        double end = endValue;
        double minValue = Math.min(startValue, endValue);
        if (minValue <= 0.0) {
            offset = minValue - 0.5;
            start = start + 0.5 - minValue;
            end = end + 0.5 - minValue;
        }
        return offset + Math.exp(Math.log(start) + (Math.log(end) - Math.log(start)) * (x / duration));
    }

    private double calculateLinearIncreaseAndDeclineValue(double x, double baseValue, double peakValue, double peakTime, double duration) {
        double tmpX = x;
        if (x > peakTime) {
            tmpX = peakTime - (x - peakTime) * peakTime / (duration - peakTime);
        }
        return baseValue + (peakValue - baseValue) / peakTime * tmpX;
    }

    private double calculateExponentialIncreaseAndDeclineValue(double x, double baseValue, double peakValue, double peakTime, double duration) {
        double tmpX = x;
        if (x > peakTime) {
            tmpX = peakTime - (x - peakTime) * peakTime / (duration - peakTime);
        }
        return this.calculateExponentialTrendValue(tmpX, peakValue, baseValue, peakTime);
    }

    private double calculateExponentialIncreaseLogarthmicDeclineValue(double x, double baseValue, double peakValue, double peakTime, double order, double duration) {
        double tmpX = x;
        if (x > peakTime) {
            tmpX = peakTime - (x - peakTime) * peakTime / (duration - peakTime);
            return this.calculateLogarithmicTrendValue(tmpX, peakValue, baseValue, order, peakTime);
        }
        return this.calculateExponentialTrendValue(tmpX, peakValue, baseValue, peakTime);
    }
}

