/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import tools.descartes.dlim.Burst;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.assistant.Calibrator;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;

public final class BasicBurstExtractionUtilities {
    private static final double BURSTDETECTIONFACTOR = 1.2;

    private BasicBurstExtractionUtilities() {
    }

    public static void buildBurstPart(Sequence root, ExtractionDataContainer container) {
        if (container.getBursts().size() > 0) {
            double halfBurstWidth = container.getBurstWidth() / 2.0;
            DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
            Combinator burstCombinator = factory.createCombinator();
            burstCombinator.setOperator(Operator.ADD);
            Sequence burstSequence = factory.createSequence();
            burstSequence.setTerminateAfterTime(container.getDuration());
            burstSequence.setTerminateAfterLoops(1);
            burstSequence.setName("bursts");
            burstCombinator.setFunction((Function)burstSequence);
            int index = 0;
            double offsetDurationDecrement = halfBurstWidth;
            for (ArrivalRateTuple burst : container.getBursts()) {
                TimeDependentFunctionContainer offsetContainer = factory.createTimeDependentFunctionContainer();
                offsetContainer.setName("burstOffset" + index);
                offsetContainer.setDuration(burst.getTimeStamp() - offsetDurationDecrement);
                offsetDurationDecrement = container.getBurstWidth() + burst.getTimeStamp();
                TimeDependentFunctionContainer burstContainer = factory.createTimeDependentFunctionContainer();
                burstContainer.setDuration(container.getBurstWidth());
                burstContainer.setName("burst" + index);
                Burst burstFunction = BasicBurstExtractionUtilities.createBurstWithCorrectShape("");
                burstFunction.setBase(0.0);
                burstFunction.setPeakTime(halfBurstWidth);
                burstContainer.setFunction((Function)burstFunction);
                burstSequence.getSequenceFunctionContainers().add((Object)offsetContainer);
                burstSequence.getSequenceFunctionContainers().add((Object)burstContainer);
                ++index;
            }
            root.getCombine().add((Object)burstCombinator);
            index = 0;
            for (TimeDependentFunctionContainer tdfc : burstSequence.getSequenceFunctionContainers()) {
                if (tdfc.getFunction() == null || !(tdfc.getFunction() instanceof Burst)) continue;
                Burst burstFunction = (Burst)tdfc.getFunction();
                burstFunction.setPeak(BasicBurstExtractionUtilities.calibrateBurstPeakValue(root, burstFunction, container.getBursts().get(index).getArrivalRate()));
                ++index;
            }
        }
    }

    public static ArrayList<ArrivalRateTuple> getBursts(Sequence root, Sequence peakBaselineModel, ExtractionDataContainer container) {
        double timeOffset = container.getLocalMins().get(0).getTimeStamp();
        ArrayList<ArrivalRateTuple> burstList = new ArrayList<ArrivalRateTuple>();
        ModelEvaluator currentBaselineModel = new ModelEvaluator(peakBaselineModel, 5, "dlim:calibration");
        for (ArrivalRateTuple max : container.getLocalMaxes()) {
            double currentTime = max.getTimeStamp() - timeOffset;
            if (!(currentTime >= 0.0) || !(max.getArrivalRate() > currentBaselineModel.getArrivalRateAtTime(currentTime) * 1.2)) continue;
            burstList.add(new ArrivalRateTuple(currentTime, max.getArrivalRate()));
            if (burstList.size() <= 1 || !(burstList.get(burstList.size() - 1).getTimeStamp() - burstList.get(burstList.size() - 2).getTimeStamp() < container.getBurstWidth())) continue;
            if (burstList.get(burstList.size() - 1).getArrivalRate() < burstList.get(burstList.size() - 2).getArrivalRate()) {
                burstList.remove(burstList.size() - 1);
                continue;
            }
            burstList.remove(burstList.size() - 2);
        }
        return burstList;
    }

    public static double calculateBurstWidth(ExtractionDataContainer container) {
        if ((double)container.getPeakNum() > 0.0) {
            return container.getPeriod() / (double)container.getPeakNum();
        }
        if (container.getSubContainerList() != null && !container.getSubContainerList().isEmpty()) {
            return BasicBurstExtractionUtilities.calculateBurstWidth(container.getSubContainerList().get(0));
        }
        return container.getPeriod() / 2.0;
    }

    private static Burst createBurstWithCorrectShape(String shapeString) {
        try {
            return (Burst)DlimPackage.eINSTANCE.getDlimFactory().create((EClass)DlimPackage.eINSTANCE.getEClassifier(shapeString));
        }
        catch (NullPointerException e) {
            return DlimPackage.eINSTANCE.getDlimFactory().createExponentialIncreaseAndDecline();
        }
    }

    private static double calibrateBurstPeakValue(Sequence rootSequence, Burst burst, double value) {
        ModelEvaluator evaluator = new ModelEvaluator(rootSequence, 0, "dlim:calibration");
        double endValue = value;
        try {
            endValue = Calibrator.calibrateBurstPeakValue(value, burst, evaluator);
        }
        catch (CalibrationException e) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "CalibrationException:" + e.getMessage(), (Throwable)e));
        }
        return endValue;
    }
}

