/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter.utils;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.random.JDKRandomGenerator;
import tools.descartes.dlim.exporter.utils.TimeStampWriter;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public class UniformDistributionTimestampWriter
extends TimeStampWriter {
    private JDKRandomGenerator rndGenerator;
    private double duration;
    private List<String> timeStampList = new ArrayList<String>();

    public UniformDistributionTimestampWriter(JDKRandomGenerator rndGenerator) {
        this.rndGenerator = rndGenerator;
    }

    public UniformDistributionTimestampWriter(String endOfLineCharacter, JDKRandomGenerator rndGenerator) {
        super(endOfLineCharacter);
        this.rndGenerator = rndGenerator;
    }

    public void generateTimeStampsFromArrivalRates(File file, List<ArrivalRateTuple> arrRates, int decimalPlaces, double stretch, double arDevisor, double duration) {
        this.duration = duration;
        this.generateTimeStampsFromArrivalRates(file, arrRates, decimalPlaces, stretch, arDevisor);
    }

    private void addDoubleValueToList(double d) {
        if (d > this.duration * this.getStretch()) {
            d = this.duration * this.getStretch();
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.timeStampList.add(this.formatDoubleForDecimalPlaces(d));
    }

    private void printList(PrintWriter writer) {
        Collections.sort(this.timeStampList);
        for (String timeStamp : this.timeStampList) {
            writer.println(String.valueOf(timeStamp) + this.getEndOfLineCharacter());
        }
    }

    @Override
    protected void writeTimestampsForArrivalRate(PrintWriter writer, double step, double arrRate, double tmpStep, double tmpTime) {
        this.timeStampList.clear();
        double j = 0.0;
        while (j < (double)((int)(arrRate * tmpStep))) {
            double d = tmpTime + (this.rndGenerator.nextDouble() - 0.5) * (step * this.getStretch());
            this.addDoubleValueToList(d);
            j += 1.0;
        }
        this.printList(writer);
    }
}

