/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.util;

import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;

public final class TimeKeeper {
    private TimeKeeper() {
    }

    public static double calculateTimeDependentFunctionContainerTime(TimeDependentFunctionContainer elem, Double startTime) {
        elem.setFirstIterationStart(startTime.doubleValue());
        elem.setFirstIterationEnd(startTime + elem.getDuration());
        if (elem.getFunction() != null) {
            TimeKeeper.calculateSequenceTime(elem.getFunction(), startTime);
        }
        return elem.getFirstIterationEnd();
    }

    public static double calculateSequenceTime(Function f, Double startTime) {
        TimeKeeper.calculateCombinatorFunctionTimes(f, startTime);
        if (!(f instanceof Sequence)) {
            return 0.0;
        }
        Sequence seq = (Sequence)f;
        seq.setFirstIterationStart(startTime.doubleValue());
        double currentTime = startTime;
        double loopDuration = 0.0;
        for (TimeDependentFunctionContainer elem : seq.getSequenceFunctionContainers()) {
            currentTime = TimeKeeper.calculateTimeDependentFunctionContainerTime(elem, currentTime);
            loopDuration += elem.getDuration();
        }
        seq.setLoopDuration(loopDuration);
        if (seq.getTerminateAfterLoops() < 0 && seq.getTerminateAfterTime() <= 0.0) {
            seq.setFinalDuration(Double.MAX_VALUE);
        } else if (seq.getTerminateAfterLoops() < 0) {
            seq.setFinalDuration(seq.getTerminateAfterTime());
        } else if (seq.getTerminateAfterTime() <= 0.0) {
            seq.setFinalDuration((double)seq.getTerminateAfterLoops() * seq.getLoopDuration());
        } else {
            seq.setFinalDuration(Math.min((double)seq.getTerminateAfterLoops() * seq.getLoopDuration(), seq.getTerminateAfterTime()));
        }
        seq.setFirstIterationEnd(seq.getFirstIterationStart() + seq.getFinalDuration());
        return seq.getFirstIterationEnd();
    }

    private static void calculateCombinatorFunctionTimes(Function f, Double startTime) {
        for (Combinator comb : f.getCombine()) {
            if (comb.getFunction() == null) continue;
            TimeKeeper.calculateSequenceTime(comb.getFunction(), startTime);
        }
    }
}

