/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import tools.descartes.dlim.Burst;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.impl.FunctionImpl;

public abstract class BurstImpl
extends FunctionImpl
implements Burst {
    protected static final double PEAK_EDEFAULT = 2.0;
    protected double peak = 2.0;
    protected static final double BASE_EDEFAULT = 0.0;
    protected double base = 0.0;
    protected static final double PEAK_TIME_EDEFAULT = 1.0;
    protected double peakTime = 1.0;

    protected BurstImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DlimPackage.Literals.BURST;
    }

    @Override
    public double getPeak() {
        return this.peak;
    }

    @Override
    public void setPeak(double newPeak) {
        double oldPeak = this.peak;
        this.peak = newPeak;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldPeak, this.peak));
        }
    }

    @Override
    public double getBase() {
        return this.base;
    }

    @Override
    public void setBase(double newBase) {
        double oldBase = this.base;
        this.base = newBase;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldBase, this.base));
        }
    }

    @Override
    public double getPeakTime() {
        return this.peakTime;
    }

    @Override
    public void setPeakTime(double newPeakTime) {
        double oldPeakTime = this.peakTime;
        this.peakTime = newPeakTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldPeakTime, this.peakTime));
        }
    }

    @Override
    public boolean peakTimeGreaterZero(DiagnosticChain chain, Map<?, ?> context) {
        if (this.getPeakTime() <= 0.0) {
            if (chain != null) {
                chain.add((Diagnostic)new BasicDiagnostic(4, "tools.descartes.dlim", 4, "peakTime must be > 0. Use a Trend, if you want peakTime as 0.", new Object[]{this, DlimPackage.eINSTANCE.getBurst_PeakTime()}));
            }
            return false;
        }
        return true;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getPeak();
            }
            case 2: {
                return this.getBase();
            }
            case 3: {
                return this.getPeakTime();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setPeak((Double)newValue);
                return;
            }
            case 2: {
                this.setBase((Double)newValue);
                return;
            }
            case 3: {
                this.setPeakTime((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setPeak(2.0);
                return;
            }
            case 2: {
                this.setBase(0.0);
                return;
            }
            case 3: {
                this.setPeakTime(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.peak != 2.0;
            }
            case 2: {
                return this.base != 0.0;
            }
            case 3: {
                return this.peakTime != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.peakTimeGreaterZero((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (peak: ");
        result.append(this.peak);
        result.append(", base: ");
        result.append(this.base);
        result.append(", peakTime: ");
        result.append(this.peakTime);
        result.append(')');
        return result.toString();
    }
}

