/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.ReferenceClockObject;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.UnivariateFunction;

public final class ModelEvaluatorUtil {
    private static Sequence rootSequence;

    private ModelEvaluatorUtil() {
    }

    private static Sequence getRootSequence() {
        return rootSequence;
    }

    public static void setRootSequence(Sequence rootSequence) {
        ModelEvaluatorUtil.rootSequence = rootSequence;
    }

    public static double neutralElement(Operator op) {
        if (op == null) {
            return 0.0;
        }
        if (op.getLiteral().equals("DIV") || op.getLiteral().equals("MULT")) {
            return 1.0;
        }
        return 0.0;
    }

    public static double getFunctionDuration(Function f) {
        if (ModelEvaluatorUtil.getParentElement(f) != null) {
            if (ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockType().getLiteral().contains("CONTAINERCLOCK")) {
                return ModelEvaluatorUtil.getParentElement(f).getDuration();
            }
            if (ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockType().getLiteral().contains("SEQCLOCK")) {
                if (ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockObject() == null) {
                    return ModelEvaluatorUtil.getParentSequence(ModelEvaluatorUtil.getParentElement(f)).getFinalDuration();
                }
                return ModelEvaluatorUtil.getParentSequence(ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockObject()).getFinalDuration();
            }
            if (ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockType().getLiteral().contains("LOOPCLOCK")) {
                if (ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockObject() == null) {
                    return ModelEvaluatorUtil.getParentSequence(ModelEvaluatorUtil.getParentElement(f)).getLoopDuration();
                }
                return ModelEvaluatorUtil.getParentSequence(ModelEvaluatorUtil.getParentElement(f).getPointOfReferenceClockObject()).getLoopDuration();
            }
            return ModelEvaluatorUtil.getRootSequence().getFinalDuration();
        }
        if (ModelEvaluatorUtil.getParentCombinator(f) != null) {
            return ModelEvaluatorUtil.getFunctionDuration(ModelEvaluatorUtil.getParentFunction(ModelEvaluatorUtil.getParentCombinator(f)));
        }
        if (f instanceof Sequence) {
            return ((Sequence)f).getFinalDuration();
        }
        if (f.eContainer() != null && f.eContainer() instanceof UnivariateFunction) {
            return ModelEvaluatorUtil.getFunctionDuration((Function)f.eContainer());
        }
        return 0.0;
    }

    public static double getFunctionBegin(Function f) {
        if (f.eContainer() == null) {
            return 0.0;
        }
        if (ModelEvaluatorUtil.getParentElement(f) != null) {
            TimeDependentFunctionContainer parentElement = ModelEvaluatorUtil.getParentElement(f);
            if (parentElement.getPointOfReferenceClockType().getLiteral().contains("CONTAINERCLOCK")) {
                return parentElement.getFirstIterationStart();
            }
            if (parentElement.getPointOfReferenceClockType().getLiteral().contains("LOOPCLOCK") || parentElement.getPointOfReferenceClockType().getLiteral().contains("SEQCLOCK")) {
                if (parentElement.getPointOfReferenceClockObject() == null) {
                    return ModelEvaluatorUtil.getParentSequence(parentElement).getFirstIterationStart();
                }
                return ModelEvaluatorUtil.getParentSequence(parentElement.getPointOfReferenceClockObject()).getFirstIterationStart();
            }
        }
        if (ModelEvaluatorUtil.getParentCombinator(f) != null) {
            return ModelEvaluatorUtil.getFunctionBegin(ModelEvaluatorUtil.getParentFunction(ModelEvaluatorUtil.getParentCombinator(f)));
        }
        if (f.eContainer() != null && f.eContainer() instanceof UnivariateFunction) {
            return ModelEvaluatorUtil.getFunctionBegin((Function)f.eContainer());
        }
        return 0.0;
    }

    private static TimeDependentFunctionContainer getParentElement(Function f) {
        EObject parent = f.eContainer();
        if (parent != null && parent instanceof TimeDependentFunctionContainer) {
            return (TimeDependentFunctionContainer)parent;
        }
        return null;
    }

    public static Combinator getParentCombinator(Function f) {
        EObject parent = f.eContainer();
        if (parent != null && parent instanceof Combinator) {
            return (Combinator)parent;
        }
        return null;
    }

    private static Function getParentFunction(Combinator c) {
        EObject parent = c.eContainer();
        if (parent != null && parent instanceof Function) {
            return (Function)parent;
        }
        return null;
    }

    public static boolean containsInTree(EObject node, EObject leaf) {
        if (leaf.eContainer() == null) {
            return false;
        }
        if (leaf.eContainer().equals(node)) {
            return true;
        }
        return ModelEvaluatorUtil.containsInTree(node, leaf.eContainer());
    }

    public static Sequence getParentSequence(ReferenceClockObject clock) {
        EObject parent = clock.eContainer();
        return (Sequence)parent;
    }

    public static Sequence getParentSequence(TimeDependentFunctionContainer e) {
        EObject parent = e.eContainer();
        if (parent != null && parent instanceof Sequence) {
            return (Sequence)parent;
        }
        return null;
    }

    public static Sequence getRootSequence(EObject modelElement) {
        if (modelElement.eContainer() == null && modelElement instanceof Sequence) {
            return (Sequence)modelElement;
        }
        if (modelElement.eContainer() != null) {
            return ModelEvaluatorUtil.getRootSequence(modelElement.eContainer());
        }
        return null;
    }

    public static boolean containsReferenceClock(Function root) {
        ArrayList<Function> functions = new ArrayList<Function>();
        if (root instanceof Sequence) {
            Sequence sequence = (Sequence)root;
            if (sequence.getReferenceClock() != null) {
                return true;
            }
            for (Object tdfc : sequence.getSequenceFunctionContainers()) {
                Function f = tdfc.getFunction();
                if (f == null) continue;
                functions.add(f);
            }
        }
        for (Combinator c : root.getCombine()) {
            Function combF = c.getFunction();
            if (combF == null) continue;
            functions.add(c.getFunction());
        }
        if (functions.isEmpty()) {
            return false;
        }
        boolean contains = false;
        for (Function f : functions) {
            boolean bl = contains = contains || ModelEvaluatorUtil.containsReferenceClock(f);
        }
        return contains;
    }
}

