/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClockType implements Enumerator
{
    ROOT_CLOCK(0, "RootClock", "ROOTCLOCK"),
    CONTAINER_CLOCK(1, "ContainerClock", "CONTAINERCLOCK"),
    SEQUENCE_CLOCK(2, "SequenceClock", "SEQCLOCK"),
    LOOP_CLOCK(3, "LoopClock", "LOOPCLOCK");

    public static final int ROOT_CLOCK_VALUE = 0;
    public static final int CONTAINER_CLOCK_VALUE = 1;
    public static final int SEQUENCE_CLOCK_VALUE = 2;
    public static final int LOOP_CLOCK_VALUE = 3;
    private static final ClockType[] VALUES_ARRAY;
    public static final List<ClockType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClockType[]{ROOT_CLOCK, CONTAINER_CLOCK, SEQUENCE_CLOCK, LOOP_CLOCK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClockType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClockType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClockType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClockType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClockType get(int value) {
        switch (value) {
            case 0: {
                return ROOT_CLOCK;
            }
            case 1: {
                return CONTAINER_CLOCK;
            }
            case 2: {
                return SEQUENCE_CLOCK;
            }
            case 3: {
                return LOOP_CLOCK;
            }
        }
        return null;
    }

    private ClockType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

