/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;

public class SavePlotViewImageDialog
extends TitleAreaDialog {
    private static final String IMAGE_STORE_ID = "dlim.saveplotviewimage";
    private Text widthText;
    private Text imageFilePathText;
    private Text heightText;
    private String imageFilePath = "";
    private int height = 400;
    private int width = 800;
    private boolean canceled = false;

    public SavePlotViewImageDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Save Plot as PNG");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new GridLayout(1, false));
        this.createSizeParameterField(columnContainer);
        this.createImageFilePathField(columnContainer);
        return dialogContainer;
    }

    private void createImageFilePathField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Image Path: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.imageFilePathText = new Text(gridContainer, 2048);
        this.imageFilePathText.setText(ProjectManager.retrieveStringFromPreferences(IMAGE_STORE_ID));
        this.imageFilePathText.setLayoutData((Object)parameterFieldData);
        Button fileDialogButton = new Button(gridContainer, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SavePlotViewImageDialog.this.getParentShell(), 8192);
                String[] filterNames = new String[]{"PNG", "All Files"};
                String[] filterExtensions = new String[]{"*.png", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Save Plot as Image");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    SavePlotViewImageDialog.this.imageFilePathText.setText(newPath);
                }
            }
        });
    }

    private void createSizeParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(4, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel1 = new Label(gridContainer, 0);
        parameterFieldLabel1.setText("Width: ");
        GridData parameterFieldData1 = new GridData();
        parameterFieldData1.grabExcessHorizontalSpace = false;
        parameterFieldData1.horizontalAlignment = 1;
        parameterFieldData1.widthHint = 40;
        this.widthText = new Text(gridContainer, 2048);
        this.widthText.setText(String.valueOf(this.width));
        this.widthText.setLayoutData((Object)parameterFieldData1);
        Label parameterFieldLabel2 = new Label(gridContainer, 0);
        parameterFieldLabel2.setText(" Height: ");
        GridData parameterFieldData2 = new GridData();
        parameterFieldData2.grabExcessHorizontalSpace = false;
        parameterFieldData2.horizontalAlignment = 1;
        parameterFieldData2.widthHint = 40;
        this.heightText = new Text(gridContainer, 2048);
        this.heightText.setText(String.valueOf(this.height));
        this.heightText.setLayoutData((Object)parameterFieldData2);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Save Plot");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.width = Integer.parseInt(this.widthText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Width must be an Integer.", 3);
            error = true;
        }
        try {
            this.height = Integer.parseInt(this.heightText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Height must be an Integer.", 3);
            error = true;
        }
        this.imageFilePath = this.imageFilePathText.getText().trim();
        Path filePath = new Path(this.imageFilePath);
        if (!filePath.isValidPath(this.imageFilePath)) {
            this.setMessage("The image path is not valid.", 3);
            error = true;
        }
        if (!(error || filePath.getFileExtension() != null && filePath.getFileExtension().equals("png"))) {
            this.setMessage("The image must be a png.", 3);
            error = true;
        }
        if (!error) {
            ProjectManager.saveStringToPreferences(IMAGE_STORE_ID, this.imageFilePath);
            this.imageFilePath = filePath.toString();
            super.okPressed();
        }
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }
}

