/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class SelectExporterDialog
extends TitleAreaDialog {
    private List exporterList;
    private String[] labels;
    private int selectedIndex = 0;
    private boolean canceled = false;

    public SelectExporterDialog(Shell parentShell, String[] labels) {
        super(parentShell);
        this.labels = labels;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle("Select Time Stamp Exporter");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new GridLayout(1, false));
        GridData parentData = new GridData();
        parentData.grabExcessHorizontalSpace = true;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        parentData.verticalAlignment = 4;
        columnContainer.setLayoutData((Object)parentData);
        this.exporterList = new List(columnContainer, 2048);
        String[] stringArray = this.labels;
        int n = this.labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            this.exporterList.add(label);
            ++n2;
        }
        this.exporterList.select(0);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.horizontalAlignment = 4;
        textData.verticalAlignment = 4;
        this.exporterList.setLayoutData((Object)textData);
        return dialogContainer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Export Time Stamps");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        this.selectedIndex = this.exporterList.getSelectionIndex();
        if (this.selectedIndex < 0) {
            this.setMessage("Please select an Exporter.", 3);
            error = true;
        }
        if (!error) {
            super.okPressed();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    protected Point getInitialSize() {
        return new Point(360, 400);
    }
}

