/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.views;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.editor.views.PlotCanvas;

public class PlotView
extends ViewPart {
    public static final String ID = "tools.descartes.dlim.generator.plotview.views.PlotView";
    private PlotCanvas plotCanvas;
    private Sequence rootSequence = null;
    private boolean decompose = false;
    private boolean plottingFile = false;

    public void createPartControl(Composite parent) {
        this.plotCanvas = new PlotCanvas(parent, 0, true);
        this.plotCanvas.setRootSequence(this.rootSequence);
        this.hookContextMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.plotCanvas, "tools.descartes.dlim.generator.plotview.viewer");
    }

    public void updatePlot(EObject eObject) {
        this.rootSequence = (Sequence)eObject;
        this.updatePlot();
    }

    public void setDecompose(boolean decompose) {
        this.decompose = decompose;
    }

    public boolean getDecompose() {
        return this.decompose;
    }

    public void updatePlot() {
        this.plotCanvas.setRootSequence(this.rootSequence);
        this.plotCanvas.setDecompositionMode(this.decompose);
        this.plotCanvas.setPlottingFile(this.plottingFile);
        this.plotCanvas.redraw();
    }

    public void setFocus() {
        this.plotCanvas.setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PlotView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.plotCanvas);
        this.plotCanvas.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, null);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void savePlotImage(String path, int width, int height) {
        this.plotCanvas.savePlotCanvasImage(path, width, height);
    }

    public boolean isPlottingFile() {
        return this.plottingFile;
    }

    public void setPlottingFile(boolean plottingFile) {
        this.plottingFile = plottingFile;
    }

    public void setArrivalRateFileList(List<ArrivalRateTuple> arrivalRateFileList) {
        this.plotCanvas.setArrivalRateFileList(arrivalRateFileList);
    }

    public Sequence getRootSequence() {
        return this.rootSequence;
    }
}

