/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.generator.editor.views.PlotCanvas;
import tools.descartes.dlim.generator.editor.wizards.CustomDlimModelWizard;
import tools.descartes.dlim.generator.editor.wizards.DlimBurstModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimReadFileModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimSeasonalModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimTrendModelWizardPage;

public abstract class DlimModelWizardPage
extends WizardPage {
    private PlotCanvas dlimPlotter;
    private Sequence rootSequence;

    protected DlimModelWizardPage(String pageName, Sequence rootSequence) {
        super(pageName);
        this.rootSequence = rootSequence;
    }

    protected Sequence getRootSequence() {
        return this.rootSequence;
    }

    protected PlotCanvas getDlimPlotter() {
        return this.dlimPlotter;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, true);
        composite.setLayout((Layout)compositeLayout);
        GridData data1 = new GridData();
        data1.widthHint = parent.getSize().y;
        data1.horizontalAlignment = 4;
        data1.grabExcessHorizontalSpace = true;
        data1.verticalAlignment = 4;
        data1.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data1);
        Composite interactiveArea = new Composite(composite, 0);
        interactiveArea.setLayout((Layout)new GridLayout(1, true));
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = false;
        data2.grabExcessVerticalSpace = false;
        interactiveArea.setLayoutData((Object)data2);
        Composite plotterComposite = new Composite(composite, 0);
        plotterComposite.setLayout((Layout)new GridLayout(1, true));
        GridData data3 = new GridData();
        data3.heightHint = 200;
        data3.widthHint = composite.getSize().y;
        data3.horizontalAlignment = 4;
        data3.grabExcessHorizontalSpace = true;
        data3.verticalAlignment = 4;
        data3.grabExcessVerticalSpace = true;
        plotterComposite.setLayoutData((Object)data3);
        this.dlimPlotter = new PlotCanvas(plotterComposite, 0, true);
        this.dlimPlotter.setRootSequence(this.rootSequence);
        this.dlimPlotter.setRightMargin(10);
        this.dlimPlotter.setDrawLegend(false);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 4;
        data4.grabExcessHorizontalSpace = true;
        data4.verticalAlignment = 4;
        data4.grabExcessVerticalSpace = true;
        this.dlimPlotter.setLayoutData(data4);
        this.fillInteractiveArea(interactiveArea);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        return true;
    }

    protected void updatePlot() {
        this.dlimPlotter.redraw();
    }

    protected final void addValidationListener(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlimModelWizardPage.this.setPageComplete(DlimModelWizardPage.this.validatePage());
            }
        });
    }

    protected void addValidationListener(Combo combo) {
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlimModelWizardPage.this.setPageComplete(DlimModelWizardPage.this.validatePage());
            }
        });
    }

    protected Collection<String> getInitialTrendNames() {
        ArrayList<String> initialObjectNames = new ArrayList<String>();
        for (EClassifier eClassifier : DlimPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !DlimPackage.eINSTANCE.getTrend().isSuperTypeOf(eClass)) continue;
            initialObjectNames.add(eClass.getName());
        }
        Collections.sort(initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        return initialObjectNames;
    }

    public void fillPageWithHLDlimParameters(HLDlimParameterContainer container) {
        this.parseParameters(container);
        this.setPageComplete(this.validatePage());
    }

    protected abstract void fillInteractiveArea(Composite var1);

    protected abstract void parseParameters(HLDlimParameterContainer var1);

    protected CustomDlimModelWizard getDlimModelWizard() {
        if (this.getWizard() instanceof CustomDlimModelWizard) {
            return (CustomDlimModelWizard)this.getWizard();
        }
        return null;
    }

    public IWizardPage getNextPage() {
        CustomDlimModelWizard wizard = this.getDlimModelWizard();
        if (this instanceof DlimReadFileModelWizardPage && wizard.isShowSeasonalPage()) {
            return wizard.getSeasonalPage();
        }
        if ((this instanceof DlimReadFileModelWizardPage || this instanceof DlimSeasonalModelWizardPage) && wizard.isShowTrendPage()) {
            return wizard.getTrendPage();
        }
        if ((this instanceof DlimReadFileModelWizardPage || this instanceof DlimSeasonalModelWizardPage || this instanceof DlimTrendModelWizardPage) && wizard.isShowBurstPage()) {
            return wizard.getBurstPage();
        }
        return null;
    }

    public IWizardPage getPreviousPage() {
        CustomDlimModelWizard wizard = this.getDlimModelWizard();
        if (this instanceof DlimBurstModelWizardPage && wizard.isShowTrendPage()) {
            return wizard.getTrendPage();
        }
        if ((this instanceof DlimBurstModelWizardPage || this instanceof DlimTrendModelWizardPage) && wizard.isShowSeasonalPage()) {
            return wizard.getSeasonalPage();
        }
        if ((this instanceof DlimBurstModelWizardPage || this instanceof DlimTrendModelWizardPage || this instanceof DlimSeasonalModelWizardPage) && wizard.isShowReadPage()) {
            return wizard.getReadPage();
        }
        return wizard.getChoicePage();
    }
}

