/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.ModelExtractor;
import tools.descartes.dlim.extractor.utils.Autocorrelation;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;

public class LaunchExtractionDialog
extends TitleAreaDialog {
    private static final String SEASONAL_PERIOD_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.SEASONAL_PERIOD_ID";
    private static final String TREND_LENGTH_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.TREND_LENGTH_ID";
    private static final String TREND_SHAPE_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.TREND_SHAPE_ID";
    private static final String SEASONAL_SHAPE_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.SEASONAL_SHAPE_ID";
    private static final String OPERATOR_LITERAL_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.OPERATOR_LITERAL_ID";
    private static final String EXTRACT_NOISE_ID = "tools.descartes.dlim.extractor.LaunchExtractionDialog.EXTRACT_NOISE_ID";
    private Text seasonalPeriodText;
    private Text seasonalsPerTrendText;
    private Button extractNoiseButton;
    private Button autocorrelationButton;
    private Combo seasonalShapeCombo;
    private Combo trendShapeCombo;
    private Combo operatorCombo;
    private double seasonalPeriod = 24.0;
    private int seasonalsPerTrend = 7;
    private String seasonalShape = "SinTrend";
    private String trendShape = "SinTrend";
    private String operatorLiteral = "MULT";
    private boolean extractNoise = false;
    private boolean canceled = false;
    private Sequence rootSequence;
    private List<ArrivalRateTuple> readArrivalRates;

    public LaunchExtractionDialog(Shell parentShell, Sequence rootSequence, List<ArrivalRateTuple> readArrivalRates) {
        super(parentShell);
        this.rootSequence = rootSequence;
        this.readArrivalRates = readArrivalRates;
    }

    public void create() {
        super.create();
        this.setTitle("Extract Sequence from Arrival Rate File");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        Composite gridComposite = new Composite(columnContainer, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        gridComposite.setLayout((Layout)gridLayout);
        this.createSeasonalPeriodParameterField(gridComposite);
        this.createSeasonalsPerTrendParameterField(gridComposite);
        this.createExtractNoiseCheckBox(gridComposite);
        Composite formSelectionComposite = new Composite(columnContainer, 0);
        GridLayout formSelectionLayout = new GridLayout(2, false);
        formSelectionComposite.setLayout((Layout)formSelectionLayout);
        this.createSeasonalShapeSelectionField(formSelectionComposite);
        this.createTrendShapeSelectionField(formSelectionComposite);
        this.createOperatorSelectionField(formSelectionComposite);
        return dialogContainer;
    }

    private void createSeasonalPeriodParameterField(Composite container) {
        String lastSeasonalPeriod = ProjectManager.retrieveStringFromPreferences((String)SEASONAL_PERIOD_ID);
        if (!lastSeasonalPeriod.isEmpty()) {
            this.seasonalPeriod = Double.parseDouble(lastSeasonalPeriod);
        }
        Label parameterFieldLabel = new Label(container, 0);
        parameterFieldLabel.setText("Seasonal Period: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.seasonalPeriodText = new Text(container, 2048);
        this.seasonalPeriodText.setText(String.valueOf(this.seasonalPeriod));
        this.seasonalPeriodText.setLayoutData((Object)parameterFieldData);
        this.autocorrelationButton = new Button(container, 8);
        this.autocorrelationButton.setText("Detect Period");
        this.autocorrelationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            private void selected() {
                double period = Autocorrelation.seasonalPeriodUsingAutocorrelation(LaunchExtractionDialog.this.readArrivalRates);
                LaunchExtractionDialog.this.setSeasonalPeriod(period);
            }
        });
    }

    private void createSeasonalsPerTrendParameterField(Composite container) {
        String lastSeasonalsPerTrend = ProjectManager.retrieveStringFromPreferences((String)TREND_LENGTH_ID);
        if (!lastSeasonalsPerTrend.isEmpty()) {
            this.seasonalsPerTrend = Integer.parseInt(lastSeasonalsPerTrend);
        }
        Label parameterFieldLabel = new Label(container, 0);
        parameterFieldLabel.setText("    Seasonal Periods per Trend: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.seasonalsPerTrendText = new Text(container, 2048);
        this.seasonalsPerTrendText.setText(String.valueOf(this.seasonalsPerTrend));
        this.seasonalsPerTrendText.setLayoutData((Object)parameterFieldData);
    }

    private void createExtractNoiseCheckBox(Composite container) {
        boolean boxSelection = false;
        String lastExtractNoise = ProjectManager.retrieveStringFromPreferences((String)EXTRACT_NOISE_ID);
        if (!lastExtractNoise.isEmpty()) {
            boxSelection = Boolean.parseBoolean(lastExtractNoise);
        }
        this.extractNoiseButton = new Button(container, 32);
        this.extractNoiseButton.setText("Extract Noise");
        this.extractNoiseButton.setSelection(boxSelection);
    }

    private void createSeasonalShapeSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Seasonal Shape: ");
        fieldLabel.setAlignment(131072);
        this.seasonalShapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.seasonalShapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.seasonalShapeCombo.add(name);
        }
        this.seasonalShapeCombo.select(this.seasonalShapeCombo.getItemCount() - 1);
        String lastSeasonalShape = ProjectManager.retrieveStringFromPreferences((String)SEASONAL_SHAPE_ID);
        if (!lastSeasonalShape.isEmpty()) {
            this.seasonalShapeCombo.setText(lastSeasonalShape);
        }
    }

    private void createTrendShapeSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Trend Shape: ");
        fieldLabel.setAlignment(131072);
        this.trendShapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.trendShapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.trendShapeCombo.add(name);
        }
        this.trendShapeCombo.select(this.trendShapeCombo.getItemCount() - 1);
        String lastTrendShape = ProjectManager.retrieveStringFromPreferences((String)TREND_SHAPE_ID);
        if (!lastTrendShape.isEmpty()) {
            this.trendShapeCombo.setText(lastTrendShape);
        }
    }

    private void createOperatorSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Trend Operator: ");
        fieldLabel.setAlignment(131072);
        this.operatorCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.operatorCombo.setLayoutData((Object)textData);
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator op = operatorArray[n2];
            this.operatorCombo.add(op.getLiteral());
            ++n2;
        }
        this.operatorCombo.setText("MULT");
        String lastOperator = ProjectManager.retrieveStringFromPreferences((String)OPERATOR_LITERAL_ID);
        if (!lastOperator.isEmpty()) {
            this.operatorCombo.setText(lastOperator);
        }
    }

    private Collection<String> getInitialTrendNames() {
        ArrayList<String> initialObjectNames = new ArrayList<String>();
        for (EClassifier eClassifier : DlimPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !DlimPackage.eINSTANCE.getTrend().isSuperTypeOf(eClass)) continue;
            initialObjectNames.add(eClass.getName());
        }
        Collections.sort(initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        return initialObjectNames;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Extract Sequence");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.seasonalPeriod = Double.parseDouble(this.seasonalPeriodText.getText().trim());
            if (this.seasonalPeriod <= 0.0) {
                this.setMessage("Seasonal Period must be greater than 0.", 3);
                error = true;
            }
        }
        catch (NumberFormatException e) {
            this.setMessage("Seasonal Period must be a number.", 3);
            error = true;
        }
        try {
            this.seasonalsPerTrend = Integer.parseInt(this.seasonalsPerTrendText.getText().trim());
        }
        catch (NumberFormatException e) {
            this.setMessage("Seasonals per Trend must be an integer number.", 3);
            error = true;
        }
        this.extractNoise = this.extractNoiseButton.getSelection();
        ProjectManager.saveStringToPreferences((String)EXTRACT_NOISE_ID, (String)String.valueOf(this.extractNoise));
        this.seasonalShape = this.seasonalShapeCombo.getText().trim();
        ProjectManager.saveStringToPreferences((String)SEASONAL_SHAPE_ID, (String)this.seasonalShape);
        this.trendShape = this.trendShapeCombo.getText().trim();
        ProjectManager.saveStringToPreferences((String)TREND_SHAPE_ID, (String)this.trendShape);
        this.operatorLiteral = this.operatorCombo.getText().trim();
        ProjectManager.saveStringToPreferences((String)OPERATOR_LITERAL_ID, (String)this.operatorLiteral);
        if (!error) {
            ProjectManager.saveStringToPreferences((String)SEASONAL_PERIOD_ID, (String)String.valueOf(this.seasonalPeriod));
            ProjectManager.saveStringToPreferences((String)TREND_LENGTH_ID, (String)String.valueOf(this.seasonalsPerTrend));
            try {
                this.performExtraction(this.rootSequence, this.readArrivalRates, this.getSeasonalPeriod(), this.getSeasonalsPerTrend(), this.getSeasonalShape(), this.getTrendShape(), this.getOperatorLiteral(), this.isExtractNoise());
                super.okPressed();
            }
            catch (CalibrationException e) {
                this.setMessage("Model Extraction Error: " + e.getMessage(), 3);
            }
        }
    }

    protected void performExtraction(Sequence root, List<ArrivalRateTuple> arrList, double period, int seasonalsPerTrend, String seasonalShape, String trendShape, String operatorLiteral, boolean extractNoise) throws CalibrationException {
        ModelExtractor.extractArrivalRateFileIntoSequenceNoSplits((Sequence)root, arrList, (double)this.getSeasonalPeriod(), (int)this.getSeasonalsPerTrend(), (String)this.getSeasonalShape(), (String)this.getTrendShape(), (String)this.getOperatorLiteral(), (boolean)this.isExtractNoise());
    }

    public double getSeasonalPeriod() {
        return this.seasonalPeriod;
    }

    protected void setSeasonalPeriod(double seasonalPeriod) {
        this.seasonalPeriod = seasonalPeriod;
        this.seasonalPeriodText.setText(String.valueOf(seasonalPeriod));
    }

    public int getSeasonalsPerTrend() {
        return this.seasonalsPerTrend;
    }

    public String getSeasonalShape() {
        return this.seasonalShape;
    }

    public String getTrendShape() {
        return this.trendShape;
    }

    public String getOperatorLiteral() {
        return this.operatorLiteral;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    public boolean isExtractNoise() {
        return this.extractNoise;
    }
}

