/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.reader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.reader.ReadingUtils;

public final class RequestTimeSeriesReader {
    private static final double STEP = 1.0;

    private RequestTimeSeriesReader() {
    }

    public static void createArrivalRatesFromSortedTimeStamps(String path, String outputDir) {
        Path absPath = new Path(path);
        Path outPath = new Path(outputDir);
        String fileName = ReadingUtils.getFileName(path);
        outPath = outPath.append(String.valueOf(fileName) + "ArrivalRates.txt");
        double bucket = 0.0;
        int arrivalRateCounter = 0;
        try {
            String line;
            PrintWriter arrRateWriter = new PrintWriter(outPath.toString(), "UTF-8");
            BufferedReader br = new BufferedReader(new FileReader(absPath.toFile()));
            while ((line = br.readLine()) != null) {
                double timeStamp = 0.0;
                try {
                    timeStamp = Double.parseDouble(line);
                }
                catch (NumberFormatException e) {
                    line = line.substring(0, line.length() - 1);
                    timeStamp = Double.parseDouble(line);
                }
                while (timeStamp >= bucket + 1.0) {
                    RequestTimeSeriesReader.printCurrentRate(bucket + 0.5, arrivalRateCounter, arrRateWriter);
                    arrivalRateCounter = 0;
                    bucket += 1.0;
                }
                ++arrivalRateCounter;
            }
            RequestTimeSeriesReader.printCurrentRate(bucket + 0.5, arrivalRateCounter, arrRateWriter);
            br.close();
            arrRateWriter.close();
        }
        catch (IOException e) {
            Activator.getInstance().log((IStatus)new Status(1, "tools.descartes.dlim.generator", "Could not write arrival rate file", (Throwable)e));
        }
    }

    public static void createArrivalRatesFromUnsortedTimeStamps(String path, String outputDir) {
        Path absPath = new Path(path);
        if (path.startsWith("platform:/resource")) {
            String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            absPath = new Path(String.valueOf(workspacePath) + path.substring(18));
        }
        String filePath = absPath.toString();
        String fileName = ReadingUtils.getFileName(filePath);
        LinkedList<Double> timeStampList = new LinkedList<Double>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            while ((line = br.readLine()) != null) {
                line = line.substring(0, line.length() - 1);
                timeStampList.add(Double.parseDouble(line.trim()));
            }
            br.close();
            Collections.sort(timeStampList);
            RequestTimeSeriesReader.writeArrivalRatesFromTimeStamps(timeStampList, outputDir, fileName);
        }
        catch (IOException e) {
            Activator.getInstance().log((IStatus)new Status(2, "tools.descartes.dlim.generator", "Could not write arrival rate file", (Throwable)e));
        }
    }

    private static void writeArrivalRatesFromTimeStamps(LinkedList<Double> timeStampList, String outputDir, String name) throws FileNotFoundException, UnsupportedEncodingException {
        double bucket = 0.0;
        int arrivalRateCounter = 0;
        String outputPath = String.valueOf(outputDir) + "/" + name + "ArrivalRates.txt";
        PrintWriter arrRateWriter = new PrintWriter(outputPath, "UTF-8");
        for (Double timeStamp : timeStampList) {
            while (timeStamp >= bucket + 1.0) {
                RequestTimeSeriesReader.printCurrentRate(bucket + 0.5, arrivalRateCounter, arrRateWriter);
                arrivalRateCounter = 0;
                bucket += 1.0;
            }
            ++arrivalRateCounter;
        }
        RequestTimeSeriesReader.printCurrentRate(bucket + 0.5, arrivalRateCounter, arrRateWriter);
        arrRateWriter.close();
    }

    private static void printCurrentRate(double time, double arrRate, PrintWriter writer) {
        writer.println(String.valueOf(time) + "," + arrRate + ";");
    }
}

