/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator;

public class ArrivalRateTuple
implements Comparable<ArrivalRateTuple> {
    private static boolean sortByTime = false;
    private double timeStamp;
    private double arrivalRate;

    public ArrivalRateTuple(double timeStamp, double arrivalRate) {
        this.timeStamp = timeStamp;
        this.arrivalRate = arrivalRate;
    }

    public double getStep(ArrivalRateTuple t) {
        if (t == null) {
            return this.timeStamp * 2.0;
        }
        return Math.abs(t.getTimeStamp() - this.timeStamp);
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.arrivalRate);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.timeStamp);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrivalRateTuple other = (ArrivalRateTuple)obj;
        if (Double.doubleToLongBits(this.arrivalRate) != Double.doubleToLongBits(other.arrivalRate)) {
            return false;
        }
        return Double.doubleToLongBits(this.timeStamp) == Double.doubleToLongBits(other.timeStamp);
    }

    public double getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(double timeStamp) {
        this.timeStamp = timeStamp;
    }

    public double getArrivalRate() {
        return this.arrivalRate;
    }

    public void setArrivalRate(double arrivalRate) {
        this.arrivalRate = arrivalRate;
    }

    public static boolean isSortByTime() {
        return sortByTime;
    }

    public static void setSortByTime(boolean sortByTime) {
        ArrivalRateTuple.sortByTime = sortByTime;
    }

    @Override
    public int compareTo(ArrivalRateTuple o) {
        if (sortByTime) {
            if (this.timeStamp < o.getTimeStamp()) {
                return -1;
            }
            if (this.timeStamp > o.getTimeStamp()) {
                return 1;
            }
        } else {
            if (this.arrivalRate < o.getArrivalRate()) {
                return -1;
            }
            if (this.arrivalRate > o.getArrivalRate()) {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.timeStamp) + "," + this.arrivalRate + ";";
    }

    public ArrivalRateTuple clone() {
        return new ArrivalRateTuple(this.timeStamp, this.arrivalRate);
    }
}

