/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import java.util.Collection;
import java.util.Set;
import javax.measure.unit.SI;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public abstract class ProjectedCRS<C extends Coordinates<?>>
extends CoordinateReferenceSystem<C> {
    public static final CoordinateSystem EASTING_NORTHING_CS = new CoordinateSystem(){
        CoordinateReferenceSystem.Axis eastingAxis = new CoordinateReferenceSystem.Axis("Easting", "E", SI.METRE, AxisDirection.EAST);
        CoordinateReferenceSystem.Axis northingAxis = new CoordinateReferenceSystem.Axis("Northing", "N", SI.METRE, AxisDirection.NORTH);

        public int getDimension() {
            return 2;
        }

        public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
            if (dimension == 0) {
                return this.eastingAxis;
            }
            if (dimension == 1) {
                return this.northingAxis;
            }
            throw new IndexOutOfBoundsException();
        }

        public Identifier getName() {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getAlias() {
            return EMPTY_SET;
        }

        public Set<String> getIdentifiers() {
            return EMPTY_SET;
        }

        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    };
}

