/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.util.List;
import javolution.context.ObjectFactory;
import javolution.text.Text;
import javolution.text.TextBuilder;
import org.jscience.mathematics.function.Function;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.Field;

public class RationalFunction<F extends Field<F>>
extends Function<F, F>
implements Field<RationalFunction<F>> {
    private Polynomial<F> _dividend;
    private Polynomial<F> _divisor;
    private static final ObjectFactory<RationalFunction> FACTORY = new ObjectFactory<RationalFunction>(){

        protected RationalFunction create() {
            return new RationalFunction();
        }

        protected void cleanup(RationalFunction rf) {
            rf._dividend = null;
            rf._divisor = null;
        }
    };
    private static final long serialVersionUID = 1L;

    private RationalFunction() {
    }

    public Polynomial<F> getDividend() {
        return this._dividend;
    }

    public Polynomial<F> getDivisor() {
        return this._divisor;
    }

    public static <F extends Field<F>> RationalFunction<F> valueOf(Polynomial<F> dividend, Polynomial<F> divisor) {
        RationalFunction rf = (RationalFunction)FACTORY.object();
        rf._dividend = dividend;
        rf._divisor = divisor;
        return rf;
    }

    @Override
    public RationalFunction<F> plus(RationalFunction<F> that) {
        return RationalFunction.valueOf(this._dividend.times(that._divisor).plus(this._divisor.times(that._dividend)), this._divisor.times(that._divisor));
    }

    @Override
    public RationalFunction<F> opposite() {
        return RationalFunction.valueOf(this._dividend.opposite(), this._divisor);
    }

    public RationalFunction<F> minus(RationalFunction<F> that) {
        return this.plus((RationalFunction<F>)that.opposite());
    }

    @Override
    public RationalFunction<F> times(RationalFunction<F> that) {
        return RationalFunction.valueOf(this._dividend.times(that._dividend), this._divisor.times(that._divisor));
    }

    @Override
    public RationalFunction<F> inverse() {
        return RationalFunction.valueOf(this._divisor, this._dividend);
    }

    public RationalFunction<F> divide(RationalFunction<F> that) {
        return this.times((RationalFunction<F>)that.inverse());
    }

    @Override
    public List<Variable<F>> getVariables() {
        return RationalFunction.merge(this._dividend.getVariables(), this._divisor.getVariables());
    }

    @Override
    public F evaluate() {
        return (F)((Field)this._dividend.evaluate()).times((Field)((Field)this._divisor.evaluate()).inverse());
    }

    @Override
    public Text toText() {
        TextBuilder tb = TextBuilder.newInstance();
        tb.append('(');
        tb.append(this._dividend);
        tb.append(")/(");
        tb.append(this._divisor);
        tb.append(')');
        return tb.toText();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RationalFunction) {
            RationalFunction that = (RationalFunction)obj;
            return this._dividend.equals(this._dividend) && this._divisor.equals(that._divisor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._dividend.hashCode() - this._divisor.hashCode();
    }

    public RationalFunction<F> differentiate(Variable<F> v) {
        return RationalFunction.valueOf(this._divisor.times((Polynomial<F>)this._dividend.differentiate((Variable)v)).plus((Polynomial<F>)this._dividend.times((Polynomial<F>)this._divisor.differentiate((Variable)v)).opposite()), this._dividend.pow(2));
    }

    @Override
    public Function<F, F> plus(Function<F, F> that) {
        return that instanceof RationalFunction ? this.plus((RationalFunction)that) : super.plus(that);
    }

    @Override
    public Function<F, F> minus(Function<F, F> that) {
        return that instanceof RationalFunction ? this.minus((RationalFunction)that) : super.minus(that);
    }

    @Override
    public Function<F, F> times(Function<F, F> that) {
        return that instanceof RationalFunction ? this.times((RationalFunction)that) : super.times(that);
    }

    @Override
    public Function<F, F> divide(Function<F, F> that) {
        return that instanceof RationalFunction ? this.divide((RationalFunction)that) : super.divide(that);
    }

    public RationalFunction<F> pow(int n) {
        return (RationalFunction)super.pow(n);
    }

    public RationalFunction<F> copy() {
        return RationalFunction.valueOf(this._dividend.copy(), this._divisor.copy());
    }
}

