/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.LargeInteger;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.number.Real;
import org.jscience.mathematics.structure.Field;

public final class FloatingPoint
extends Number<FloatingPoint>
implements Field<FloatingPoint> {
    static final XMLFormat<FloatingPoint> XML = new XMLFormat<FloatingPoint>(FloatingPoint.class){

        public FloatingPoint newInstance(Class<FloatingPoint> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return FloatingPoint.valueOf((CharSequence)xml.getAttribute("value"));
        }

        public void write(FloatingPoint FloatingPoint2, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (CharSequence)FloatingPoint2.toText());
        }

        public void read(XMLFormat.InputElement xml, FloatingPoint FloatingPoint2) {
        }
    };
    private static final ObjectFactory<FloatingPoint> FACTORY = new ObjectFactory<FloatingPoint>(){

        protected FloatingPoint create() {
            return new FloatingPoint();
        }
    };
    public static final FloatingPoint ZERO = new FloatingPoint(LargeInteger.ZERO, 0);
    public static final FloatingPoint ONE = new FloatingPoint(LargeInteger.ONE, 0);
    public static final FloatingPoint NaN = new FloatingPoint(LargeInteger.ZERO, Integer.MAX_VALUE);
    private static final LocalContext.Reference<Integer> DIGITS = new LocalContext.Reference((Object)20);
    private LargeInteger _significand;
    private int _exponent;
    private static final long serialVersionUID = 1L;

    private FloatingPoint() {
    }

    private FloatingPoint(LargeInteger significand, int exponent) {
        this._significand = significand;
        this._exponent = exponent;
    }

    public static FloatingPoint valueOf(LargeInteger significand, int exponent) {
        FloatingPoint fp = (FloatingPoint)FACTORY.object();
        fp._significand = significand;
        fp._exponent = exponent;
        return fp;
    }

    public static FloatingPoint valueOf(long significand, int exponent) {
        FloatingPoint fp = (FloatingPoint)FACTORY.object();
        fp._significand = LargeInteger.valueOf(significand);
        fp._exponent = exponent;
        return fp;
    }

    public static FloatingPoint valueOf(long longValue) {
        return FloatingPoint.valueOf(longValue, 0);
    }

    public static FloatingPoint valueOf(double doubleValue) {
        if (doubleValue == 0.0) {
            return ZERO;
        }
        if (doubleValue == 1.0) {
            return ONE;
        }
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return NaN;
        }
        int e = MathLib.floorLog10((double)MathLib.abs((double)doubleValue)) - 18 + 1;
        long significand = MathLib.toLongPow10((double)doubleValue, (int)(-e));
        return FloatingPoint.valueOf(significand, e);
    }

    public static FloatingPoint valueOf(CharSequence chars) {
        Real real = Real.valueOf(chars);
        if (real.getError() != 0) {
            throw new IllegalArgumentException("No error allowed");
        }
        return FloatingPoint.valueOf(real.getSignificand(), real.getExponent());
    }

    public static int getDigits() {
        return (Integer)DIGITS.get();
    }

    public static void setDigits(int digits) {
        if (digits <= 0) {
            throw new IllegalArgumentException("digits: " + digits + " has to be greater than 0");
        }
        DIGITS.set((Object)digits);
    }

    public LargeInteger getSignificand() {
        return this._significand;
    }

    public int getExponent() {
        return this._exponent;
    }

    public LargeInteger round() {
        if (this == NaN) {
            throw new ArithmeticException("Cannot convert NaN to integer value");
        }
        LargeInteger half = LargeInteger.FIVE.times10pow(-this._exponent - 1);
        return this.isNegative() ? this._significand.minus(half).times10pow(this._exponent) : this._significand.plus(half).times10pow(this._exponent);
    }

    @Override
    public FloatingPoint opposite() {
        return FloatingPoint.valueOf(this._significand.opposite(), this._exponent);
    }

    @Override
    public FloatingPoint plus(FloatingPoint that) {
        if (this._exponent > that._exponent) {
            return that.plus(this);
        }
        int pow10Scaling = that._exponent - this._exponent;
        LargeInteger thatScaled = that._significand.times10pow(pow10Scaling);
        return FloatingPoint.valueOf(this._significand.plus(thatScaled), this._exponent).normalize();
    }

    @Override
    public FloatingPoint minus(FloatingPoint that) {
        if (this._exponent > that._exponent) {
            return that.opposite().plus(this);
        }
        int pow10Scaling = that._exponent - this._exponent;
        LargeInteger thatScaled = that._significand.times10pow(pow10Scaling);
        return FloatingPoint.valueOf(this._significand.minus(thatScaled), this._exponent).normalize();
    }

    @Override
    public FloatingPoint times(long multiplier) {
        return this.times(FloatingPoint.valueOf(multiplier));
    }

    @Override
    public FloatingPoint times(FloatingPoint that) {
        return FloatingPoint.valueOf(this._significand.times(that._significand), this._exponent + that._exponent).normalize();
    }

    @Override
    public FloatingPoint inverse() {
        if (this._significand.isZero()) {
            return NaN;
        }
        int pow10 = (Integer)DIGITS.get() + this._significand.digitLength();
        LargeInteger dividend = LargeInteger.ONE.times10pow(pow10);
        return FloatingPoint.valueOf(dividend.divide(this._significand), -pow10 - this._exponent).normalize();
    }

    public FloatingPoint divide(FloatingPoint that) {
        if (that._significand.isZero()) {
            return NaN;
        }
        int pow10 = (Integer)DIGITS.get() + that._significand.digitLength();
        LargeInteger dividend = this._significand.times10pow(pow10);
        return FloatingPoint.valueOf(dividend.divide(that._significand), this._exponent - pow10 - that._exponent).normalize();
    }

    public FloatingPoint abs() {
        return FloatingPoint.valueOf(this._significand.abs(), this._exponent);
    }

    public FloatingPoint sqrt() {
        if (this == NaN) {
            return NaN;
        }
        if (this.isZero()) {
            return ZERO;
        }
        int pow10 = (Integer)DIGITS.get() * 2 - this._significand.digitLength();
        int exp = this._exponent - pow10;
        if ((exp & 1) == 1) {
            ++pow10;
            --exp;
        }
        LargeInteger scaledValue = this._significand.times10pow(pow10);
        return FloatingPoint.valueOf(scaledValue.sqrt(), exp >> 1).normalize();
    }

    public boolean isZero() {
        return this._significand.isZero() && this != NaN;
    }

    public boolean isPositive() {
        return this._significand.isPositive();
    }

    public boolean isNegative() {
        return this._significand.isNegative();
    }

    public boolean isNaN() {
        return this == NaN;
    }

    @Override
    public boolean isLargerThan(FloatingPoint that) {
        return this.abs().compareTo(that.abs()) > 0;
    }

    @Override
    public Text toText() {
        if (this == NaN) {
            return Text.valueOf((Object)"NaN");
        }
        if (this._significand.isZero()) {
            return Text.valueOf((Object)"0.0");
        }
        TextBuilder tb = TextBuilder.newInstance();
        LargeInteger m = this._significand;
        if (this.isNegative()) {
            tb.append('-');
            m = m.opposite();
        }
        tb.append("0.");
        LargeInteger.DECIMAL_FORMAT.format((Object)m, tb);
        int exp = this._exponent + m.digitLength();
        if (exp != 0) {
            tb.append("E");
            tb.append(this._exponent + m.digitLength());
        }
        Text txt = tb.toText();
        TextBuilder.recycle((TextBuilder)tb);
        return txt;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof FloatingPoint) {
            return this.minus((FloatingPoint)that).isZero();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long mult;
        if (this.isZero()) {
            return 0;
        }
        if (this.isNaN()) {
            return 483929293;
        }
        long code = this._significand.hashCode();
        int exp = this._exponent;
        if (exp < 0) {
            mult = 398143210L;
            exp = -exp;
        } else {
            mult = 10L;
        }
        while (exp != 0) {
            if (1 == exp % 2) {
                code = code * mult % 1327144033L;
            }
            mult = mult * mult % 1327144033L;
            exp /= 2;
        }
        return (int)code;
    }

    @Override
    public long longValue() {
        Real real = Real.valueOf(this._significand, 0, this._exponent);
        return real.longValue();
    }

    @Override
    public double doubleValue() {
        Real real = Real.valueOf(this._significand, 0, this._exponent);
        return real.doubleValue();
    }

    @Override
    public int compareTo(FloatingPoint that) {
        FloatingPoint diff = this.minus(that);
        if (diff.isPositive()) {
            return 1;
        }
        if (diff.isNegative()) {
            return -1;
        }
        return 0;
    }

    private FloatingPoint normalize() {
        int digits = FloatingPoint.getDigits();
        int thisDigits = this._significand.digitLength();
        if (thisDigits > digits) {
            int pow10 = digits - thisDigits;
            this._significand = this._significand.times10pow(pow10);
            long exponent = (long)this._exponent - (long)pow10;
            if (exponent > Integer.MAX_VALUE) {
                return NaN;
            }
            if (exponent < Integer.MIN_VALUE) {
                return ZERO;
            }
            this._exponent = (int)exponent;
        }
        return this;
    }

    @Override
    public FloatingPoint copy() {
        if (this == NaN) {
            return NaN;
        }
        FloatingPoint r = (FloatingPoint)FACTORY.object();
        r._significand = this._significand.copy();
        r._exponent = this._exponent;
        return r;
    }
}

